<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelAgencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
 * tours.
 * @subpackage Structs
 */
class TravelAgencyType extends AbstractStructBase
{
    /**
     * The AgencyID
     * Meta information extracted from the WSDL
     * - documentation: Unique Agency Seller ID. Example: CTRV | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AgencyID;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * The IATA_Number
     * Meta information extracted from the WSDL
     * - documentation: IATA-assigned agency number. Example: 98417900 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $IATA_Number;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Agency name. Example: Carson Travel | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PseudoCityID
     * Meta information extracted from the WSDL
     * - documentation: An identifier for a corporate user of a computer reservation system (CRS) or global distribution system (GDS), typically a travel agency. Also known as Office ID. | An identifier is a character string used to uniquely identify one
     * instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PseudoCityID;
    /**
     * The TravelAgent
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and
     * package tours.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelAgentType
     */
    public $TravelAgent;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Agency type code. Examples TravelAgency, OnlineTravelAgency, or TravelManagementCompany. | Additional BDT to specify travel agency type codes.
     * - base: TravelAgencyTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * Constructor method for TravelAgencyType
     * @uses TravelAgencyType::setAgencyID()
     * @uses TravelAgencyType::setContactInfo()
     * @uses TravelAgencyType::setIATA_Number()
     * @uses TravelAgencyType::setName()
     * @uses TravelAgencyType::setPseudoCityID()
     * @uses TravelAgencyType::setTravelAgent()
     * @uses TravelAgencyType::setTypeCode()
     * @param string $agencyID
     * @param \StructType\ContactInfoType[] $contactInfo
     * @param float $iATA_Number
     * @param string $name
     * @param string $pseudoCityID
     * @param \StructType\TravelAgentType $travelAgent
     * @param string $typeCode
     */
    public function __construct($agencyID = null, array $contactInfo = array(), $iATA_Number = null, $name = null, $pseudoCityID = null, \StructType\TravelAgentType $travelAgent = null, $typeCode = null)
    {
        $this
            ->setAgencyID($agencyID)
            ->setContactInfo($contactInfo)
            ->setIATA_Number($iATA_Number)
            ->setName($name)
            ->setPseudoCityID($pseudoCityID)
            ->setTravelAgent($travelAgent)
            ->setTypeCode($typeCode);
    }
    /**
     * Get AgencyID value
     * @return string
     */
    public function getAgencyID()
    {
        return $this->AgencyID;
    }
    /**
     * Set AgencyID value
     * @param string $agencyID
     * @return \StructType\TravelAgencyType
     */
    public function setAgencyID($agencyID = null)
    {
        // validation for constraint: string
        if (!is_null($agencyID) && !is_string($agencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyID, true), gettype($agencyID)), __LINE__);
        }
        $this->AgencyID = $agencyID;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelAgencyTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$travelAgencyTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($travelAgencyTypeContactInfoItem) ? get_class($travelAgencyTypeContactInfoItem) : sprintf('%s(%s)', gettype($travelAgencyTypeContactInfoItem), var_export($travelAgencyTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\TravelAgencyType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\TravelAgencyType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get IATA_Number value
     * @return float|null
     */
    public function getIATA_Number()
    {
        return $this->IATA_Number;
    }
    /**
     * Set IATA_Number value
     * @param float $iATA_Number
     * @return \StructType\TravelAgencyType
     */
    public function setIATA_Number($iATA_Number = null)
    {
        // validation for constraint: float
        if (!is_null($iATA_Number) && !(is_float($iATA_Number) || is_numeric($iATA_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iATA_Number, true), gettype($iATA_Number)), __LINE__);
        }
        $this->IATA_Number = $iATA_Number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TravelAgencyType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PseudoCityID value
     * @return string|null
     */
    public function getPseudoCityID()
    {
        return $this->PseudoCityID;
    }
    /**
     * Set PseudoCityID value
     * @param string $pseudoCityID
     * @return \StructType\TravelAgencyType
     */
    public function setPseudoCityID($pseudoCityID = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityID) && !is_string($pseudoCityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityID, true), gettype($pseudoCityID)), __LINE__);
        }
        $this->PseudoCityID = $pseudoCityID;
        return $this;
    }
    /**
     * Get TravelAgent value
     * @return \StructType\TravelAgentType|null
     */
    public function getTravelAgent()
    {
        return $this->TravelAgent;
    }
    /**
     * Set TravelAgent value
     * @param \StructType\TravelAgentType $travelAgent
     * @return \StructType\TravelAgencyType
     */
    public function setTravelAgent(\StructType\TravelAgentType $travelAgent = null)
    {
        $this->TravelAgent = $travelAgent;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\TravelAgencyType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
}
