<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketType StructType
 * Meta information extracted from the WSDL
 * - documentation: The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
 * @subpackage Structs
 */
class TicketType extends AbstractStructBase
{
    /**
     * The Coupon
     * Meta information extracted from the WSDL
     * - documentation: The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\CouponType[]
     */
    public $Coupon;
    /**
     * The ReportingTypeCode
     * Meta information extracted from the WSDL
     * - documentation: For billing and settlement purposes, each time a travel agent requests an airline to perform an action on a document (Issuance, Refund, Exchange), he needs to know how to reconcile this action (via BSP, ARC, directly by ORA, etc.). |
     * BDT for Reporting Type Code BBIE.
     * - base: ReportingTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReportingTypeCode;
    /**
     * The ConnectedDocNumber
     * Meta information extracted from the WSDL
     * - documentation: The ticket/ document number to which this document is connected. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ConnectedDocNumber;
    /**
     * The ExchReissueInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the specified ticket/document number is on behalf of a document which has been exchanged or reissued. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExchReissueInd;
    /**
     * The FeeOwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $FeeOwnerCode;
    /**
     * The PresentCreditCardInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the credit/debit card used for purchase must be presented. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PresentCreditCardInd;
    /**
     * The PrimaryDocInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this is the primary ticket/document number. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PrimaryDocInd;
    /**
     * The RemarkText
     * Meta information extracted from the WSDL
     * - documentation: Free text to provide further information related to the document. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemarkText;
    /**
     * The RoutingCode
     * Meta information extracted from the WSDL
     * - documentation: For EMD-A and EMD-S tickets with routing. Use 'D' if all board and off points are within the same country and 'I' if all board and of points are not within the same country. For EMD-S with no routing, do not use. | A code is a
     * character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingCode;
    /**
     * The TaxOnEMD_Ind
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, a tax has been collected and is due to a local government from the validating carrier. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TaxOnEMD_Ind;
    /**
     * The TicketDocTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Document type code as defined by PADIS 1001 (Document/ Message Name, coded). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketDocTypeCode;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The document number comprised of the airline code, form code, and serial number. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * Constructor method for TicketType
     * @uses TicketType::setCoupon()
     * @uses TicketType::setReportingTypeCode()
     * @uses TicketType::setConnectedDocNumber()
     * @uses TicketType::setExchReissueInd()
     * @uses TicketType::setFeeOwnerCode()
     * @uses TicketType::setPresentCreditCardInd()
     * @uses TicketType::setPrimaryDocInd()
     * @uses TicketType::setRemarkText()
     * @uses TicketType::setRoutingCode()
     * @uses TicketType::setTaxOnEMD_Ind()
     * @uses TicketType::setTicketDocTypeCode()
     * @uses TicketType::setTicketNumber()
     * @param \StructType\CouponType[] $coupon
     * @param string $reportingTypeCode
     * @param float $connectedDocNumber
     * @param bool $exchReissueInd
     * @param string $feeOwnerCode
     * @param bool $presentCreditCardInd
     * @param bool $primaryDocInd
     * @param string $remarkText
     * @param string $routingCode
     * @param bool $taxOnEMD_Ind
     * @param string $ticketDocTypeCode
     * @param string $ticketNumber
     */
    public function __construct(array $coupon = array(), $reportingTypeCode = null, $connectedDocNumber = null, $exchReissueInd = null, $feeOwnerCode = null, $presentCreditCardInd = null, $primaryDocInd = null, $remarkText = null, $routingCode = null, $taxOnEMD_Ind = null, $ticketDocTypeCode = null, $ticketNumber = null)
    {
        $this
            ->setCoupon($coupon)
            ->setReportingTypeCode($reportingTypeCode)
            ->setConnectedDocNumber($connectedDocNumber)
            ->setExchReissueInd($exchReissueInd)
            ->setFeeOwnerCode($feeOwnerCode)
            ->setPresentCreditCardInd($presentCreditCardInd)
            ->setPrimaryDocInd($primaryDocInd)
            ->setRemarkText($remarkText)
            ->setRoutingCode($routingCode)
            ->setTaxOnEMD_Ind($taxOnEMD_Ind)
            ->setTicketDocTypeCode($ticketDocTypeCode)
            ->setTicketNumber($ticketNumber);
    }
    /**
     * Get Coupon value
     * @return \StructType\CouponType[]
     */
    public function getCoupon()
    {
        return $this->Coupon;
    }
    /**
     * This method is responsible for validating the values passed to the setCoupon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoupon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponForArrayConstraintsFromSetCoupon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketTypeCouponItem) {
            // validation for constraint: itemType
            if (!$ticketTypeCouponItem instanceof \StructType\CouponType) {
                $invalidValues[] = is_object($ticketTypeCouponItem) ? get_class($ticketTypeCouponItem) : sprintf('%s(%s)', gettype($ticketTypeCouponItem), var_export($ticketTypeCouponItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coupon property can only contain items of type \StructType\CouponType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coupon value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponType[] $coupon
     * @return \StructType\TicketType
     */
    public function setCoupon(array $coupon = array())
    {
        // validation for constraint: array
        if ('' !== ($couponArrayErrorMessage = self::validateCouponForArrayConstraintsFromSetCoupon($coupon))) {
            throw new \InvalidArgumentException($couponArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($coupon) && count($coupon) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($coupon)), __LINE__);
        }
        $this->Coupon = $coupon;
        return $this;
    }
    /**
     * Add item to Coupon value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponType $item
     * @return \StructType\TicketType
     */
    public function addToCoupon(\StructType\CouponType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponType) {
            throw new \InvalidArgumentException(sprintf('The Coupon property can only contain items of type \StructType\CouponType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Coupon) && count($this->Coupon) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Coupon)), __LINE__);
        }
        $this->Coupon[] = $item;
        return $this;
    }
    /**
     * Get ReportingTypeCode value
     * @return string
     */
    public function getReportingTypeCode()
    {
        return $this->ReportingTypeCode;
    }
    /**
     * Set ReportingTypeCode value
     * @param string $reportingTypeCode
     * @return \StructType\TicketType
     */
    public function setReportingTypeCode($reportingTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportingTypeCode) && !is_string($reportingTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingTypeCode, true), gettype($reportingTypeCode)), __LINE__);
        }
        $this->ReportingTypeCode = $reportingTypeCode;
        return $this;
    }
    /**
     * Get ConnectedDocNumber value
     * @return float|null
     */
    public function getConnectedDocNumber()
    {
        return $this->ConnectedDocNumber;
    }
    /**
     * Set ConnectedDocNumber value
     * @param float $connectedDocNumber
     * @return \StructType\TicketType
     */
    public function setConnectedDocNumber($connectedDocNumber = null)
    {
        // validation for constraint: float
        if (!is_null($connectedDocNumber) && !(is_float($connectedDocNumber) || is_numeric($connectedDocNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($connectedDocNumber, true), gettype($connectedDocNumber)), __LINE__);
        }
        $this->ConnectedDocNumber = $connectedDocNumber;
        return $this;
    }
    /**
     * Get ExchReissueInd value
     * @return bool|null
     */
    public function getExchReissueInd()
    {
        return $this->ExchReissueInd;
    }
    /**
     * Set ExchReissueInd value
     * @param bool $exchReissueInd
     * @return \StructType\TicketType
     */
    public function setExchReissueInd($exchReissueInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchReissueInd) && !is_bool($exchReissueInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchReissueInd, true), gettype($exchReissueInd)), __LINE__);
        }
        $this->ExchReissueInd = $exchReissueInd;
        return $this;
    }
    /**
     * Get FeeOwnerCode value
     * @return string|null
     */
    public function getFeeOwnerCode()
    {
        return $this->FeeOwnerCode;
    }
    /**
     * Set FeeOwnerCode value
     * @param string $feeOwnerCode
     * @return \StructType\TicketType
     */
    public function setFeeOwnerCode($feeOwnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($feeOwnerCode) && !is_string($feeOwnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeOwnerCode, true), gettype($feeOwnerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($feeOwnerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $feeOwnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($feeOwnerCode, true)), __LINE__);
        }
        $this->FeeOwnerCode = $feeOwnerCode;
        return $this;
    }
    /**
     * Get PresentCreditCardInd value
     * @return bool|null
     */
    public function getPresentCreditCardInd()
    {
        return $this->PresentCreditCardInd;
    }
    /**
     * Set PresentCreditCardInd value
     * @param bool $presentCreditCardInd
     * @return \StructType\TicketType
     */
    public function setPresentCreditCardInd($presentCreditCardInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($presentCreditCardInd) && !is_bool($presentCreditCardInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($presentCreditCardInd, true), gettype($presentCreditCardInd)), __LINE__);
        }
        $this->PresentCreditCardInd = $presentCreditCardInd;
        return $this;
    }
    /**
     * Get PrimaryDocInd value
     * @return bool|null
     */
    public function getPrimaryDocInd()
    {
        return $this->PrimaryDocInd;
    }
    /**
     * Set PrimaryDocInd value
     * @param bool $primaryDocInd
     * @return \StructType\TicketType
     */
    public function setPrimaryDocInd($primaryDocInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryDocInd) && !is_bool($primaryDocInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryDocInd, true), gettype($primaryDocInd)), __LINE__);
        }
        $this->PrimaryDocInd = $primaryDocInd;
        return $this;
    }
    /**
     * Get RemarkText value
     * @return string|null
     */
    public function getRemarkText()
    {
        return $this->RemarkText;
    }
    /**
     * Set RemarkText value
     * @param string $remarkText
     * @return \StructType\TicketType
     */
    public function setRemarkText($remarkText = null)
    {
        // validation for constraint: string
        if (!is_null($remarkText) && !is_string($remarkText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkText, true), gettype($remarkText)), __LINE__);
        }
        $this->RemarkText = $remarkText;
        return $this;
    }
    /**
     * Get RoutingCode value
     * @return string|null
     */
    public function getRoutingCode()
    {
        return $this->RoutingCode;
    }
    /**
     * Set RoutingCode value
     * @param string $routingCode
     * @return \StructType\TicketType
     */
    public function setRoutingCode($routingCode = null)
    {
        // validation for constraint: string
        if (!is_null($routingCode) && !is_string($routingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingCode, true), gettype($routingCode)), __LINE__);
        }
        $this->RoutingCode = $routingCode;
        return $this;
    }
    /**
     * Get TaxOnEMD_Ind value
     * @return bool|null
     */
    public function getTaxOnEMD_Ind()
    {
        return $this->TaxOnEMD_Ind;
    }
    /**
     * Set TaxOnEMD_Ind value
     * @param bool $taxOnEMD_Ind
     * @return \StructType\TicketType
     */
    public function setTaxOnEMD_Ind($taxOnEMD_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxOnEMD_Ind) && !is_bool($taxOnEMD_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxOnEMD_Ind, true), gettype($taxOnEMD_Ind)), __LINE__);
        }
        $this->TaxOnEMD_Ind = $taxOnEMD_Ind;
        return $this;
    }
    /**
     * Get TicketDocTypeCode value
     * @return string|null
     */
    public function getTicketDocTypeCode()
    {
        return $this->TicketDocTypeCode;
    }
    /**
     * Set TicketDocTypeCode value
     * @param string $ticketDocTypeCode
     * @return \StructType\TicketType
     */
    public function setTicketDocTypeCode($ticketDocTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocTypeCode) && !is_string($ticketDocTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocTypeCode, true), gettype($ticketDocTypeCode)), __LINE__);
        }
        $this->TicketDocTypeCode = $ticketDocTypeCode;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\TicketType
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
}
