<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a specialization of the ticket class for use has filter criteria base definition: The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
 * @subpackage Structs
 */
class TicketFilterCriteriaType extends AbstractStructBase
{
    /**
     * The IssueDateRange
     * Meta information extracted from the WSDL
     * - documentation: Date range information for filter criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRangeType
     */
    public $IssueDateRange;
    /**
     * The TicketingLocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketingLocationCode;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The document number comprised of the airline code, form code, and serial number. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * Constructor method for TicketFilterCriteriaType
     * @uses TicketFilterCriteriaType::setIssueDateRange()
     * @uses TicketFilterCriteriaType::setTicketingLocationCode()
     * @uses TicketFilterCriteriaType::setTicketNumber()
     * @param \StructType\DateRangeType $issueDateRange
     * @param string $ticketingLocationCode
     * @param string $ticketNumber
     */
    public function __construct(\StructType\DateRangeType $issueDateRange = null, $ticketingLocationCode = null, $ticketNumber = null)
    {
        $this
            ->setIssueDateRange($issueDateRange)
            ->setTicketingLocationCode($ticketingLocationCode)
            ->setTicketNumber($ticketNumber);
    }
    /**
     * Get IssueDateRange value
     * @return \StructType\DateRangeType|null
     */
    public function getIssueDateRange()
    {
        return $this->IssueDateRange;
    }
    /**
     * Set IssueDateRange value
     * @param \StructType\DateRangeType $issueDateRange
     * @return \StructType\TicketFilterCriteriaType
     */
    public function setIssueDateRange(\StructType\DateRangeType $issueDateRange = null)
    {
        $this->IssueDateRange = $issueDateRange;
        return $this;
    }
    /**
     * Get TicketingLocationCode value
     * @return string|null
     */
    public function getTicketingLocationCode()
    {
        return $this->TicketingLocationCode;
    }
    /**
     * Set TicketingLocationCode value
     * @param string $ticketingLocationCode
     * @return \StructType\TicketFilterCriteriaType
     */
    public function setTicketingLocationCode($ticketingLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingLocationCode) && !is_string($ticketingLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingLocationCode, true), gettype($ticketingLocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($ticketingLocationCode) && mb_strlen($ticketingLocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($ticketingLocationCode)), __LINE__);
        }
        $this->TicketingLocationCode = $ticketingLocationCode;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\TicketFilterCriteriaType
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
}
