<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermType StructType
 * Meta information extracted from the WSDL
 * - documentation: Condition under which an agreement is reached.
 * @subpackage Structs
 */
class TermType extends AbstractStructBase
{
    /**
     * The TermID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier associated to a term instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TermID;
    /**
     * The AvailPeriod
     * Meta information extracted from the WSDL
     * - documentation: Earliest and Latest Period than an option is available or may be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AvailPeriodType
     */
    public $AvailPeriod;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The OrderingQty
     * Meta information extracted from the WSDL
     * - documentation: Minimum/Maximum Option Ordering Quantities.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderingQtyType
     */
    public $OrderingQty;
    /**
     * Constructor method for TermType
     * @uses TermType::setTermID()
     * @uses TermType::setAvailPeriod()
     * @uses TermType::setDesc()
     * @uses TermType::setOrderingQty()
     * @param string $termID
     * @param \StructType\AvailPeriodType $availPeriod
     * @param \StructType\DescType $desc
     * @param \StructType\OrderingQtyType $orderingQty
     */
    public function __construct($termID = null, \StructType\AvailPeriodType $availPeriod = null, \StructType\DescType $desc = null, \StructType\OrderingQtyType $orderingQty = null)
    {
        $this
            ->setTermID($termID)
            ->setAvailPeriod($availPeriod)
            ->setDesc($desc)
            ->setOrderingQty($orderingQty);
    }
    /**
     * Get TermID value
     * @return string
     */
    public function getTermID()
    {
        return $this->TermID;
    }
    /**
     * Set TermID value
     * @param string $termID
     * @return \StructType\TermType
     */
    public function setTermID($termID = null)
    {
        // validation for constraint: string
        if (!is_null($termID) && !is_string($termID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termID, true), gettype($termID)), __LINE__);
        }
        $this->TermID = $termID;
        return $this;
    }
    /**
     * Get AvailPeriod value
     * @return \StructType\AvailPeriodType|null
     */
    public function getAvailPeriod()
    {
        return $this->AvailPeriod;
    }
    /**
     * Set AvailPeriod value
     * @param \StructType\AvailPeriodType $availPeriod
     * @return \StructType\TermType
     */
    public function setAvailPeriod(\StructType\AvailPeriodType $availPeriod = null)
    {
        $this->AvailPeriod = $availPeriod;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\TermType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get OrderingQty value
     * @return \StructType\OrderingQtyType|null
     */
    public function getOrderingQty()
    {
        return $this->OrderingQty;
    }
    /**
     * Set OrderingQty value
     * @param \StructType\OrderingQtyType $orderingQty
     * @return \StructType\TermType
     */
    public function setOrderingQty(\StructType\OrderingQtyType $orderingQty = null)
    {
        $this->OrderingQty = $orderingQty;
        return $this;
    }
}
