<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxonomyFeatureType StructType
 * Meta information extracted from the WSDL
 * - documentation: Bilaterally agreed mechanism to describe specific product and service information to the Seller as defined by the Airline. This defines a further level of definition for a airline taxonomy code. e.g meal (TC 03F0) -> breakfast(03F1)
 * - eggs(03F2),toast(03F3)
 * @subpackage Structs
 */
class TaxonomyFeatureType extends AbstractStructBase
{
    /**
     * The CodesetCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the codeset code that is being used in each entry related to the specified codeset defined. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodesetCode;
    /**
     * The CodesetNameCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the codeset that is being used in each entry to define the codeset code and the associated value text. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodesetNameCode;
    /**
     * The ValueText
     * Meta information extracted from the WSDL
     * - documentation: The textural description associated to the codeset code for a given defined codeset. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueText;
    /**
     * Constructor method for TaxonomyFeatureType
     * @uses TaxonomyFeatureType::setCodesetCode()
     * @uses TaxonomyFeatureType::setCodesetNameCode()
     * @uses TaxonomyFeatureType::setValueText()
     * @param string $codesetCode
     * @param string $codesetNameCode
     * @param string $valueText
     */
    public function __construct($codesetCode = null, $codesetNameCode = null, $valueText = null)
    {
        $this
            ->setCodesetCode($codesetCode)
            ->setCodesetNameCode($codesetNameCode)
            ->setValueText($valueText);
    }
    /**
     * Get CodesetCode value
     * @return string|null
     */
    public function getCodesetCode()
    {
        return $this->CodesetCode;
    }
    /**
     * Set CodesetCode value
     * @param string $codesetCode
     * @return \StructType\TaxonomyFeatureType
     */
    public function setCodesetCode($codesetCode = null)
    {
        // validation for constraint: string
        if (!is_null($codesetCode) && !is_string($codesetCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codesetCode, true), gettype($codesetCode)), __LINE__);
        }
        $this->CodesetCode = $codesetCode;
        return $this;
    }
    /**
     * Get CodesetNameCode value
     * @return string|null
     */
    public function getCodesetNameCode()
    {
        return $this->CodesetNameCode;
    }
    /**
     * Set CodesetNameCode value
     * @param string $codesetNameCode
     * @return \StructType\TaxonomyFeatureType
     */
    public function setCodesetNameCode($codesetNameCode = null)
    {
        // validation for constraint: string
        if (!is_null($codesetNameCode) && !is_string($codesetNameCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codesetNameCode, true), gettype($codesetNameCode)), __LINE__);
        }
        $this->CodesetNameCode = $codesetNameCode;
        return $this;
    }
    /**
     * Get ValueText value
     * @return string|null
     */
    public function getValueText()
    {
        return $this->ValueText;
    }
    /**
     * Set ValueText value
     * @param string $valueText
     * @return \StructType\TaxonomyFeatureType
     */
    public function setValueText($valueText = null)
    {
        // validation for constraint: string
        if (!is_null($valueText) && !is_string($valueText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueText, true), gettype($valueText)), __LINE__);
        }
        $this->ValueText = $valueText;
        return $this;
    }
}
