<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierOfferedServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
 * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class SupplierOfferedServiceType extends AbstractStructBase
{
    /**
     * The OfferServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Offer Service Association
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OfferServiceAssociationType
     */
    public $OfferServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The InventoryGuaranteeDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time inventory against a given Service is guaranteed. If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed. Notes: The presence of an
     * inventory guarantee does not assume a guarantee of price. For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present. The assumption is that inventory is held when an Order is created (or changed),
     * so this time limit only applies in the context of an Offer. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InventoryGuaranteeDateTime;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The SettlementConditionCode
     * Meta information extracted from the WSDL
     * - documentation: either 'Immediate' or 'Delivery' | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementConditionCode;
    /**
     * The SettlementTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: A date/time by which settlement must occur. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementTimeLimitDateTime;
    /**
     * The SettlementValue
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierPriceType
     */
    public $SettlementValue;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for SupplierOfferedServiceType
     * @uses SupplierOfferedServiceType::setOfferServiceAssociation()
     * @uses SupplierOfferedServiceType::setPaxRefID()
     * @uses SupplierOfferedServiceType::setServiceID()
     * @uses SupplierOfferedServiceType::setAirlineTaxonomy()
     * @uses SupplierOfferedServiceType::setInventoryGuaranteeDateTime()
     * @uses SupplierOfferedServiceType::setServiceRefID()
     * @uses SupplierOfferedServiceType::setSettlementConditionCode()
     * @uses SupplierOfferedServiceType::setSettlementTimeLimitDateTime()
     * @uses SupplierOfferedServiceType::setSettlementValue()
     * @uses SupplierOfferedServiceType::setValidatingCarrier()
     * @param \StructType\OfferServiceAssociationType $offerServiceAssociation
     * @param string[] $paxRefID
     * @param string $serviceID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param string $inventoryGuaranteeDateTime
     * @param string $serviceRefID
     * @param string $settlementConditionCode
     * @param string $settlementTimeLimitDateTime
     * @param \StructType\SupplierPriceType $settlementValue
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct(\StructType\OfferServiceAssociationType $offerServiceAssociation = null, array $paxRefID = array(), $serviceID = null, array $airlineTaxonomy = array(), $inventoryGuaranteeDateTime = null, $serviceRefID = null, $settlementConditionCode = null, $settlementTimeLimitDateTime = null, \StructType\SupplierPriceType $settlementValue = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setOfferServiceAssociation($offerServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setServiceID($serviceID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime)
            ->setServiceRefID($serviceRefID)
            ->setSettlementConditionCode($settlementConditionCode)
            ->setSettlementTimeLimitDateTime($settlementTimeLimitDateTime)
            ->setSettlementValue($settlementValue)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get OfferServiceAssociation value
     * @return \StructType\OfferServiceAssociationType
     */
    public function getOfferServiceAssociation()
    {
        return $this->OfferServiceAssociation;
    }
    /**
     * Set OfferServiceAssociation value
     * @param \StructType\OfferServiceAssociationType $offerServiceAssociation
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setOfferServiceAssociation(\StructType\OfferServiceAssociationType $offerServiceAssociation = null)
    {
        $this->OfferServiceAssociation = $offerServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferedServiceTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($supplierOfferedServiceTypePaxRefIDItem)) {
                $invalidValues[] = is_object($supplierOfferedServiceTypePaxRefIDItem) ? get_class($supplierOfferedServiceTypePaxRefIDItem) : sprintf('%s(%s)', gettype($supplierOfferedServiceTypePaxRefIDItem), var_export($supplierOfferedServiceTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplierOfferedServiceType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferedServiceTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$supplierOfferedServiceTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($supplierOfferedServiceTypeAirlineTaxonomyItem) ? get_class($supplierOfferedServiceTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($supplierOfferedServiceTypeAirlineTaxonomyItem), var_export($supplierOfferedServiceTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\SupplierOfferedServiceType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get InventoryGuaranteeDateTime value
     * @return string|null
     */
    public function getInventoryGuaranteeDateTime()
    {
        return $this->InventoryGuaranteeDateTime;
    }
    /**
     * Set InventoryGuaranteeDateTime value
     * @param string $inventoryGuaranteeDateTime
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryGuaranteeDateTime) && !is_string($inventoryGuaranteeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryGuaranteeDateTime, true), gettype($inventoryGuaranteeDateTime)), __LINE__);
        }
        $this->InventoryGuaranteeDateTime = $inventoryGuaranteeDateTime;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get SettlementConditionCode value
     * @return string|null
     */
    public function getSettlementConditionCode()
    {
        return $this->SettlementConditionCode;
    }
    /**
     * Set SettlementConditionCode value
     * @param string $settlementConditionCode
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setSettlementConditionCode($settlementConditionCode = null)
    {
        // validation for constraint: string
        if (!is_null($settlementConditionCode) && !is_string($settlementConditionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementConditionCode, true), gettype($settlementConditionCode)), __LINE__);
        }
        $this->SettlementConditionCode = $settlementConditionCode;
        return $this;
    }
    /**
     * Get SettlementTimeLimitDateTime value
     * @return string|null
     */
    public function getSettlementTimeLimitDateTime()
    {
        return $this->SettlementTimeLimitDateTime;
    }
    /**
     * Set SettlementTimeLimitDateTime value
     * @param string $settlementTimeLimitDateTime
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setSettlementTimeLimitDateTime($settlementTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($settlementTimeLimitDateTime) && !is_string($settlementTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementTimeLimitDateTime, true), gettype($settlementTimeLimitDateTime)), __LINE__);
        }
        $this->SettlementTimeLimitDateTime = $settlementTimeLimitDateTime;
        return $this;
    }
    /**
     * Get SettlementValue value
     * @return \StructType\SupplierPriceType|null
     */
    public function getSettlementValue()
    {
        return $this->SettlementValue;
    }
    /**
     * Set SettlementValue value
     * @param \StructType\SupplierPriceType $settlementValue
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setSettlementValue(\StructType\SupplierPriceType $settlementValue = null)
    {
        $this->SettlementValue = $settlementValue;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\SupplierOfferedServiceType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
