<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: New Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
 * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
 * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
 * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
 * @subpackage Structs
 */
class SupplierOfferType extends AbstractStructBase
{
    /**
     * The OfferID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Offer across several messages. Offer ID facilitates the tracking and verification of individually priced offer(s) selected from the shopping response. Only the Offer IDs of the
     * ORA (Offer Responsible Airline) are returned in shopping responses. Offer ID is unique to each individually priced offer in the shopping response even if the offer price is zero. Offer ID may be specific to individual passengers in the offer, and may
     * be associated with a segment or a journey. The set of Offer IDs returned in a response are referenced by a Shopping Response ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The BaggageDisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Bag Disclosure ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $BaggageDisclosureRefID;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Disclosure ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisclosureRefID;
    /**
     * The MatchAppText
     * Meta information extracted from the WSDL
     * - documentation: Specifies which type of flight request the match information relate to (examples: Attribute, Affinity, Other). | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MatchAppText;
    /**
     * The MatchPercent
     * Meta information extracted from the WSDL
     * - documentation: Offer match percentage to shopping criteria type. This information should be populated when there is a partial match of the initial shopping criteria. Example: 60 | A percent is a value representing a fraction of one
     * hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MatchPercent;
    /**
     * The MatchTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Offer match to shopping criteria type. Examples: Full, None, Partial, Other Note: An additional percentage qualifier, such as 50%, may be specified for a Partial match. | Data type for Offer Match Result ENUMs.
     * - base: MatchTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MatchTypeCode;
    /**
     * The OfferExpirationTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time an offer will persist in an airline's offer management system for use in subsequent transactions. Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again.
     * Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer. Should the offer time limit expire, any other time limit also expires unless an Order has been created or
     * changed. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferExpirationTimeLimitDateTime;
    /**
     * The OwnerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether or not the owner is the Supplier or Retailer. | Specifies the type of Owner for a given Offer/Order/Order Item (E.g. ORA, POA).
     * - base: OwnerTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerTypeCode;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The PTC_OfferParameters
     * Meta information extracted from the WSDL
     * - documentation: Passenger Type summary information for an offer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PTC_OfferParametersType[]
     */
    public $PTC_OfferParameters;
    /**
     * The RedemptionInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this Offer must be redeemed, e.g. it cannot be purchased. Note: Taxes may still apply. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RedemptionInd;
    /**
     * The RequestedDateInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if
     * airline offer is for another date than requested one. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RequestedDateInd;
    /**
     * The SupplierOfferItem
     * Meta information extracted from the WSDL
     * - documentation: A priced grouping of one or more services within an Offer. The New Offer Item assigns a total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierOfferItemType[]
     */
    public $SupplierOfferItem;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierPriceType
     */
    public $TotalPrice;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for SupplierOfferType
     * @uses SupplierOfferType::setOfferID()
     * @uses SupplierOfferType::setOwnerCode()
     * @uses SupplierOfferType::setBaggageDisclosureRefID()
     * @uses SupplierOfferType::setDescText()
     * @uses SupplierOfferType::setDisclosureRefID()
     * @uses SupplierOfferType::setMatchAppText()
     * @uses SupplierOfferType::setMatchPercent()
     * @uses SupplierOfferType::setMatchTypeCode()
     * @uses SupplierOfferType::setOfferExpirationTimeLimitDateTime()
     * @uses SupplierOfferType::setOwnerTypeCode()
     * @uses SupplierOfferType::setPenaltyRefID()
     * @uses SupplierOfferType::setPTC_OfferParameters()
     * @uses SupplierOfferType::setRedemptionInd()
     * @uses SupplierOfferType::setRequestedDateInd()
     * @uses SupplierOfferType::setSupplierOfferItem()
     * @uses SupplierOfferType::setTotalPrice()
     * @uses SupplierOfferType::setWebAddressURI()
     * @param string $offerID
     * @param string $ownerCode
     * @param string[] $baggageDisclosureRefID
     * @param string $descText
     * @param string $disclosureRefID
     * @param string $matchAppText
     * @param float $matchPercent
     * @param string $matchTypeCode
     * @param string $offerExpirationTimeLimitDateTime
     * @param string $ownerTypeCode
     * @param string[] $penaltyRefID
     * @param \StructType\PTC_OfferParametersType[] $pTC_OfferParameters
     * @param bool $redemptionInd
     * @param bool $requestedDateInd
     * @param \StructType\SupplierOfferItemType[] $supplierOfferItem
     * @param \StructType\SupplierPriceType $totalPrice
     * @param string $webAddressURI
     */
    public function __construct($offerID = null, $ownerCode = null, array $baggageDisclosureRefID = array(), $descText = null, $disclosureRefID = null, $matchAppText = null, $matchPercent = null, $matchTypeCode = null, $offerExpirationTimeLimitDateTime = null, $ownerTypeCode = null, array $penaltyRefID = array(), array $pTC_OfferParameters = array(), $redemptionInd = null, $requestedDateInd = null, array $supplierOfferItem = array(), \StructType\SupplierPriceType $totalPrice = null, $webAddressURI = null)
    {
        $this
            ->setOfferID($offerID)
            ->setOwnerCode($ownerCode)
            ->setBaggageDisclosureRefID($baggageDisclosureRefID)
            ->setDescText($descText)
            ->setDisclosureRefID($disclosureRefID)
            ->setMatchAppText($matchAppText)
            ->setMatchPercent($matchPercent)
            ->setMatchTypeCode($matchTypeCode)
            ->setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime)
            ->setOwnerTypeCode($ownerTypeCode)
            ->setPenaltyRefID($penaltyRefID)
            ->setPTC_OfferParameters($pTC_OfferParameters)
            ->setRedemptionInd($redemptionInd)
            ->setRequestedDateInd($requestedDateInd)
            ->setSupplierOfferItem($supplierOfferItem)
            ->setTotalPrice($totalPrice)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OfferID value
     * @return string
     */
    public function getOfferID()
    {
        return $this->OfferID;
    }
    /**
     * Set OfferID value
     * @param string $offerID
     * @return \StructType\SupplierOfferType
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerID, true), gettype($offerID)), __LINE__);
        }
        $this->OfferID = $offerID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SupplierOfferType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get BaggageDisclosureRefID value
     * @return string[]|null
     */
    public function getBaggageDisclosureRefID()
    {
        return $this->BaggageDisclosureRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageDisclosureRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageDisclosureRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageDisclosureRefIDForArrayConstraintsFromSetBaggageDisclosureRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferTypeBaggageDisclosureRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($supplierOfferTypeBaggageDisclosureRefIDItem)) {
                $invalidValues[] = is_object($supplierOfferTypeBaggageDisclosureRefIDItem) ? get_class($supplierOfferTypeBaggageDisclosureRefIDItem) : sprintf('%s(%s)', gettype($supplierOfferTypeBaggageDisclosureRefIDItem), var_export($supplierOfferTypeBaggageDisclosureRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageDisclosureRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageDisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageDisclosureRefID
     * @return \StructType\SupplierOfferType
     */
    public function setBaggageDisclosureRefID(array $baggageDisclosureRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageDisclosureRefIDArrayErrorMessage = self::validateBaggageDisclosureRefIDForArrayConstraintsFromSetBaggageDisclosureRefID($baggageDisclosureRefID))) {
            throw new \InvalidArgumentException($baggageDisclosureRefIDArrayErrorMessage, __LINE__);
        }
        $this->BaggageDisclosureRefID = $baggageDisclosureRefID;
        return $this;
    }
    /**
     * Add item to BaggageDisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplierOfferType
     */
    public function addToBaggageDisclosureRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageDisclosureRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageDisclosureRefID[] = $item;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\SupplierOfferType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * Set DisclosureRefID value
     * @param string $disclosureRefID
     * @return \StructType\SupplierOfferType
     */
    public function setDisclosureRefID($disclosureRefID = null)
    {
        // validation for constraint: string
        if (!is_null($disclosureRefID) && !is_string($disclosureRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclosureRefID, true), gettype($disclosureRefID)), __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Get MatchAppText value
     * @return string|null
     */
    public function getMatchAppText()
    {
        return $this->MatchAppText;
    }
    /**
     * Set MatchAppText value
     * @param string $matchAppText
     * @return \StructType\SupplierOfferType
     */
    public function setMatchAppText($matchAppText = null)
    {
        // validation for constraint: string
        if (!is_null($matchAppText) && !is_string($matchAppText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchAppText, true), gettype($matchAppText)), __LINE__);
        }
        $this->MatchAppText = $matchAppText;
        return $this;
    }
    /**
     * Get MatchPercent value
     * @return float|null
     */
    public function getMatchPercent()
    {
        return $this->MatchPercent;
    }
    /**
     * Set MatchPercent value
     * @param float $matchPercent
     * @return \StructType\SupplierOfferType
     */
    public function setMatchPercent($matchPercent = null)
    {
        // validation for constraint: float
        if (!is_null($matchPercent) && !(is_float($matchPercent) || is_numeric($matchPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchPercent, true), gettype($matchPercent)), __LINE__);
        }
        $this->MatchPercent = $matchPercent;
        return $this;
    }
    /**
     * Get MatchTypeCode value
     * @return string|null
     */
    public function getMatchTypeCode()
    {
        return $this->MatchTypeCode;
    }
    /**
     * Set MatchTypeCode value
     * @param string $matchTypeCode
     * @return \StructType\SupplierOfferType
     */
    public function setMatchTypeCode($matchTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($matchTypeCode) && !is_string($matchTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchTypeCode, true), gettype($matchTypeCode)), __LINE__);
        }
        $this->MatchTypeCode = $matchTypeCode;
        return $this;
    }
    /**
     * Get OfferExpirationTimeLimitDateTime value
     * @return string|null
     */
    public function getOfferExpirationTimeLimitDateTime()
    {
        return $this->OfferExpirationTimeLimitDateTime;
    }
    /**
     * Set OfferExpirationTimeLimitDateTime value
     * @param string $offerExpirationTimeLimitDateTime
     * @return \StructType\SupplierOfferType
     */
    public function setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($offerExpirationTimeLimitDateTime) && !is_string($offerExpirationTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerExpirationTimeLimitDateTime, true), gettype($offerExpirationTimeLimitDateTime)), __LINE__);
        }
        $this->OfferExpirationTimeLimitDateTime = $offerExpirationTimeLimitDateTime;
        return $this;
    }
    /**
     * Get OwnerTypeCode value
     * @return string|null
     */
    public function getOwnerTypeCode()
    {
        return $this->OwnerTypeCode;
    }
    /**
     * Set OwnerTypeCode value
     * @param string $ownerTypeCode
     * @return \StructType\SupplierOfferType
     */
    public function setOwnerTypeCode($ownerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerTypeCode) && !is_string($ownerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerTypeCode, true), gettype($ownerTypeCode)), __LINE__);
        }
        $this->OwnerTypeCode = $ownerTypeCode;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($supplierOfferTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($supplierOfferTypePenaltyRefIDItem) ? get_class($supplierOfferTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($supplierOfferTypePenaltyRefIDItem), var_export($supplierOfferTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\SupplierOfferType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplierOfferType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get PTC_OfferParameters value
     * @return \StructType\PTC_OfferParametersType[]|null
     */
    public function getPTC_OfferParameters()
    {
        return $this->PTC_OfferParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setPTC_OfferParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPTC_OfferParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePTC_OfferParametersForArrayConstraintsFromSetPTC_OfferParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferTypePTC_OfferParametersItem) {
            // validation for constraint: itemType
            if (!$supplierOfferTypePTC_OfferParametersItem instanceof \StructType\PTC_OfferParametersType) {
                $invalidValues[] = is_object($supplierOfferTypePTC_OfferParametersItem) ? get_class($supplierOfferTypePTC_OfferParametersItem) : sprintf('%s(%s)', gettype($supplierOfferTypePTC_OfferParametersItem), var_export($supplierOfferTypePTC_OfferParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PTC_OfferParameters property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PTC_OfferParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType[] $pTC_OfferParameters
     * @return \StructType\SupplierOfferType
     */
    public function setPTC_OfferParameters(array $pTC_OfferParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($pTC_OfferParametersArrayErrorMessage = self::validatePTC_OfferParametersForArrayConstraintsFromSetPTC_OfferParameters($pTC_OfferParameters))) {
            throw new \InvalidArgumentException($pTC_OfferParametersArrayErrorMessage, __LINE__);
        }
        $this->PTC_OfferParameters = $pTC_OfferParameters;
        return $this;
    }
    /**
     * Add item to PTC_OfferParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType $item
     * @return \StructType\SupplierOfferType
     */
    public function addToPTC_OfferParameters(\StructType\PTC_OfferParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTC_OfferParametersType) {
            throw new \InvalidArgumentException(sprintf('The PTC_OfferParameters property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PTC_OfferParameters[] = $item;
        return $this;
    }
    /**
     * Get RedemptionInd value
     * @return bool|null
     */
    public function getRedemptionInd()
    {
        return $this->RedemptionInd;
    }
    /**
     * Set RedemptionInd value
     * @param bool $redemptionInd
     * @return \StructType\SupplierOfferType
     */
    public function setRedemptionInd($redemptionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($redemptionInd) && !is_bool($redemptionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redemptionInd, true), gettype($redemptionInd)), __LINE__);
        }
        $this->RedemptionInd = $redemptionInd;
        return $this;
    }
    /**
     * Get RequestedDateInd value
     * @return bool|null
     */
    public function getRequestedDateInd()
    {
        return $this->RequestedDateInd;
    }
    /**
     * Set RequestedDateInd value
     * @param bool $requestedDateInd
     * @return \StructType\SupplierOfferType
     */
    public function setRequestedDateInd($requestedDateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestedDateInd) && !is_bool($requestedDateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requestedDateInd, true), gettype($requestedDateInd)), __LINE__);
        }
        $this->RequestedDateInd = $requestedDateInd;
        return $this;
    }
    /**
     * Get SupplierOfferItem value
     * @return \StructType\SupplierOfferItemType[]|null
     */
    public function getSupplierOfferItem()
    {
        return $this->SupplierOfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierOfferItemForArrayConstraintsFromSetSupplierOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferTypeSupplierOfferItemItem) {
            // validation for constraint: itemType
            if (!$supplierOfferTypeSupplierOfferItemItem instanceof \StructType\SupplierOfferItemType) {
                $invalidValues[] = is_object($supplierOfferTypeSupplierOfferItemItem) ? get_class($supplierOfferTypeSupplierOfferItemItem) : sprintf('%s(%s)', gettype($supplierOfferTypeSupplierOfferItemItem), var_export($supplierOfferTypeSupplierOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierOfferItem property can only contain items of type \StructType\SupplierOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferItemType[] $supplierOfferItem
     * @return \StructType\SupplierOfferType
     */
    public function setSupplierOfferItem(array $supplierOfferItem = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierOfferItemArrayErrorMessage = self::validateSupplierOfferItemForArrayConstraintsFromSetSupplierOfferItem($supplierOfferItem))) {
            throw new \InvalidArgumentException($supplierOfferItemArrayErrorMessage, __LINE__);
        }
        $this->SupplierOfferItem = $supplierOfferItem;
        return $this;
    }
    /**
     * Add item to SupplierOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferItemType $item
     * @return \StructType\SupplierOfferType
     */
    public function addToSupplierOfferItem(\StructType\SupplierOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The SupplierOfferItem property can only contain items of type \StructType\SupplierOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplierOfferItem[] = $item;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\SupplierPriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\SupplierPriceType $totalPrice
     * @return \StructType\SupplierOfferType
     */
    public function setTotalPrice(\StructType\SupplierPriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\SupplierOfferType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
