<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A priced grouping of one or more services within an Offer. The New Offer Item assigns a total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
 * @subpackage Structs
 */
class SupplierOfferItemType extends AbstractStructBase
{
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. Exceeding 64 characters or use of dashes is not recommended. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Offered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
     * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SupplierOfferedServiceType[]
     */
    public $Service;
    /**
     * The AcceptanceRule
     * Meta information extracted from the WSDL
     * - documentation: A rule which is an account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AcceptanceRuleType[]
     */
    public $AcceptanceRule;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The CombinableCarrier
     * Meta information extracted from the WSDL
     * - documentation: Interline variant of the carrier abie. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * Business Identifier Fields: - Airline Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineCarrierType[]
     */
    public $CombinableCarrier;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The MinimumConnectiontimeDuration
     * Meta information extracted from the WSDL
     * - documentation: The minimum time needed for the passenger to transit from a flight service to the next flight service. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time
     * units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinimumConnectiontimeDuration;
    /**
     * The OfferItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Offer Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemTypeCode;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OwnerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether or not the owner is the Supplier or Retailer. | Specifies the type of Owner for a given Offer/Order/Order Item (E.g. ORA, POA).
     * - base: OwnerTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerTypeCode;
    /**
     * The StopOverRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Additional information supplied by the Airline for the current Itinerary to advise the Seller that additional options could be available (if the Seller changes the request) to add Stop Overs within the itinerary.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StopOverRestrictionsType[]
     */
    public $StopOverRestrictions;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierPriceType
     */
    public $TotalPrice;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for SupplierOfferItemType
     * @uses SupplierOfferItemType::setOfferItemID()
     * @uses SupplierOfferItemType::setService()
     * @uses SupplierOfferItemType::setAcceptanceRule()
     * @uses SupplierOfferItemType::setAirlineTaxonomy()
     * @uses SupplierOfferItemType::setCancelRestrictions()
     * @uses SupplierOfferItemType::setChangeRestrictions()
     * @uses SupplierOfferItemType::setCombinableCarrier()
     * @uses SupplierOfferItemType::setMandatoryInd()
     * @uses SupplierOfferItemType::setMinimumConnectiontimeDuration()
     * @uses SupplierOfferItemType::setOfferItemTypeCode()
     * @uses SupplierOfferItemType::setOwnerCode()
     * @uses SupplierOfferItemType::setOwnerTypeCode()
     * @uses SupplierOfferItemType::setStopOverRestrictions()
     * @uses SupplierOfferItemType::setTotalPrice()
     * @uses SupplierOfferItemType::setWebAddressURI()
     * @param string $offerItemID
     * @param \StructType\SupplierOfferedServiceType[] $service
     * @param \StructType\AcceptanceRuleType[] $acceptanceRule
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\InterlineCarrierType[] $combinableCarrier
     * @param bool $mandatoryInd
     * @param string $minimumConnectiontimeDuration
     * @param string $offerItemTypeCode
     * @param string $ownerCode
     * @param string $ownerTypeCode
     * @param \StructType\StopOverRestrictionsType[] $stopOverRestrictions
     * @param \StructType\SupplierPriceType $totalPrice
     * @param string $webAddressURI
     */
    public function __construct($offerItemID = null, array $service = array(), array $acceptanceRule = array(), array $airlineTaxonomy = array(), array $cancelRestrictions = array(), array $changeRestrictions = array(), array $combinableCarrier = array(), $mandatoryInd = null, $minimumConnectiontimeDuration = null, $offerItemTypeCode = null, $ownerCode = null, $ownerTypeCode = null, array $stopOverRestrictions = array(), \StructType\SupplierPriceType $totalPrice = null, $webAddressURI = null)
    {
        $this
            ->setOfferItemID($offerItemID)
            ->setService($service)
            ->setAcceptanceRule($acceptanceRule)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCombinableCarrier($combinableCarrier)
            ->setMandatoryInd($mandatoryInd)
            ->setMinimumConnectiontimeDuration($minimumConnectiontimeDuration)
            ->setOfferItemTypeCode($offerItemTypeCode)
            ->setOwnerCode($ownerCode)
            ->setOwnerTypeCode($ownerTypeCode)
            ->setStopOverRestrictions($stopOverRestrictions)
            ->setTotalPrice($totalPrice)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\SupplierOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\SupplierOfferedServiceType[]
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeServiceItem instanceof \StructType\SupplierOfferedServiceType) {
                $invalidValues[] = is_object($supplierOfferItemTypeServiceItem) ? get_class($supplierOfferItemTypeServiceItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeServiceItem), var_export($supplierOfferItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\SupplierOfferedServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferedServiceType[] $service
     * @return \StructType\SupplierOfferItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferedServiceType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToService(\StructType\SupplierOfferedServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierOfferedServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\SupplierOfferedServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get AcceptanceRule value
     * @return \StructType\AcceptanceRuleType[]|null
     */
    public function getAcceptanceRule()
    {
        return $this->AcceptanceRule;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptanceRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptanceRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptanceRuleForArrayConstraintsFromSetAcceptanceRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeAcceptanceRuleItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeAcceptanceRuleItem instanceof \StructType\AcceptanceRuleType) {
                $invalidValues[] = is_object($supplierOfferItemTypeAcceptanceRuleItem) ? get_class($supplierOfferItemTypeAcceptanceRuleItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeAcceptanceRuleItem), var_export($supplierOfferItemTypeAcceptanceRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptanceRule property can only contain items of type \StructType\AcceptanceRuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptanceRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptanceRuleType[] $acceptanceRule
     * @return \StructType\SupplierOfferItemType
     */
    public function setAcceptanceRule(array $acceptanceRule = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptanceRuleArrayErrorMessage = self::validateAcceptanceRuleForArrayConstraintsFromSetAcceptanceRule($acceptanceRule))) {
            throw new \InvalidArgumentException($acceptanceRuleArrayErrorMessage, __LINE__);
        }
        $this->AcceptanceRule = $acceptanceRule;
        return $this;
    }
    /**
     * Add item to AcceptanceRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptanceRuleType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToAcceptanceRule(\StructType\AcceptanceRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptanceRuleType) {
            throw new \InvalidArgumentException(sprintf('The AcceptanceRule property can only contain items of type \StructType\AcceptanceRuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AcceptanceRule[] = $item;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($supplierOfferItemTypeAirlineTaxonomyItem) ? get_class($supplierOfferItemTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeAirlineTaxonomyItem), var_export($supplierOfferItemTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\SupplierOfferItemType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($supplierOfferItemTypeCancelRestrictionsItem) ? get_class($supplierOfferItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeCancelRestrictionsItem), var_export($supplierOfferItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\SupplierOfferItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($supplierOfferItemTypeChangeRestrictionsItem) ? get_class($supplierOfferItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeChangeRestrictionsItem), var_export($supplierOfferItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\SupplierOfferItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get CombinableCarrier value
     * @return \StructType\InterlineCarrierType[]|null
     */
    public function getCombinableCarrier()
    {
        return $this->CombinableCarrier;
    }
    /**
     * This method is responsible for validating the values passed to the setCombinableCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCombinableCarrier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCombinableCarrierForArrayConstraintsFromSetCombinableCarrier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeCombinableCarrierItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeCombinableCarrierItem instanceof \StructType\InterlineCarrierType) {
                $invalidValues[] = is_object($supplierOfferItemTypeCombinableCarrierItem) ? get_class($supplierOfferItemTypeCombinableCarrierItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeCombinableCarrierItem), var_export($supplierOfferItemTypeCombinableCarrierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CombinableCarrier property can only contain items of type \StructType\InterlineCarrierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CombinableCarrier value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineCarrierType[] $combinableCarrier
     * @return \StructType\SupplierOfferItemType
     */
    public function setCombinableCarrier(array $combinableCarrier = array())
    {
        // validation for constraint: array
        if ('' !== ($combinableCarrierArrayErrorMessage = self::validateCombinableCarrierForArrayConstraintsFromSetCombinableCarrier($combinableCarrier))) {
            throw new \InvalidArgumentException($combinableCarrierArrayErrorMessage, __LINE__);
        }
        $this->CombinableCarrier = $combinableCarrier;
        return $this;
    }
    /**
     * Add item to CombinableCarrier value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineCarrierType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToCombinableCarrier(\StructType\InterlineCarrierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineCarrierType) {
            throw new \InvalidArgumentException(sprintf('The CombinableCarrier property can only contain items of type \StructType\InterlineCarrierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CombinableCarrier[] = $item;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\SupplierOfferItemType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get MinimumConnectiontimeDuration value
     * @return string|null
     */
    public function getMinimumConnectiontimeDuration()
    {
        return $this->MinimumConnectiontimeDuration;
    }
    /**
     * Set MinimumConnectiontimeDuration value
     * @param string $minimumConnectiontimeDuration
     * @return \StructType\SupplierOfferItemType
     */
    public function setMinimumConnectiontimeDuration($minimumConnectiontimeDuration = null)
    {
        // validation for constraint: string
        if (!is_null($minimumConnectiontimeDuration) && !is_string($minimumConnectiontimeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumConnectiontimeDuration, true), gettype($minimumConnectiontimeDuration)), __LINE__);
        }
        $this->MinimumConnectiontimeDuration = $minimumConnectiontimeDuration;
        return $this;
    }
    /**
     * Get OfferItemTypeCode value
     * @return string|null
     */
    public function getOfferItemTypeCode()
    {
        return $this->OfferItemTypeCode;
    }
    /**
     * Set OfferItemTypeCode value
     * @param string $offerItemTypeCode
     * @return \StructType\SupplierOfferItemType
     */
    public function setOfferItemTypeCode($offerItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemTypeCode) && !is_string($offerItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemTypeCode, true), gettype($offerItemTypeCode)), __LINE__);
        }
        $this->OfferItemTypeCode = $offerItemTypeCode;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SupplierOfferItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OwnerTypeCode value
     * @return string|null
     */
    public function getOwnerTypeCode()
    {
        return $this->OwnerTypeCode;
    }
    /**
     * Set OwnerTypeCode value
     * @param string $ownerTypeCode
     * @return \StructType\SupplierOfferItemType
     */
    public function setOwnerTypeCode($ownerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerTypeCode) && !is_string($ownerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerTypeCode, true), gettype($ownerTypeCode)), __LINE__);
        }
        $this->OwnerTypeCode = $ownerTypeCode;
        return $this;
    }
    /**
     * Get StopOverRestrictions value
     * @return \StructType\StopOverRestrictionsType[]|null
     */
    public function getStopOverRestrictions()
    {
        return $this->StopOverRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setStopOverRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStopOverRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStopOverRestrictionsForArrayConstraintsFromSetStopOverRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOfferItemTypeStopOverRestrictionsItem) {
            // validation for constraint: itemType
            if (!$supplierOfferItemTypeStopOverRestrictionsItem instanceof \StructType\StopOverRestrictionsType) {
                $invalidValues[] = is_object($supplierOfferItemTypeStopOverRestrictionsItem) ? get_class($supplierOfferItemTypeStopOverRestrictionsItem) : sprintf('%s(%s)', gettype($supplierOfferItemTypeStopOverRestrictionsItem), var_export($supplierOfferItemTypeStopOverRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StopOverRestrictions property can only contain items of type \StructType\StopOverRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StopOverRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\StopOverRestrictionsType[] $stopOverRestrictions
     * @return \StructType\SupplierOfferItemType
     */
    public function setStopOverRestrictions(array $stopOverRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($stopOverRestrictionsArrayErrorMessage = self::validateStopOverRestrictionsForArrayConstraintsFromSetStopOverRestrictions($stopOverRestrictions))) {
            throw new \InvalidArgumentException($stopOverRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->StopOverRestrictions = $stopOverRestrictions;
        return $this;
    }
    /**
     * Add item to StopOverRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\StopOverRestrictionsType $item
     * @return \StructType\SupplierOfferItemType
     */
    public function addToStopOverRestrictions(\StructType\StopOverRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopOverRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The StopOverRestrictions property can only contain items of type \StructType\StopOverRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StopOverRestrictions[] = $item;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\SupplierPriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\SupplierPriceType $totalPrice
     * @return \StructType\SupplierOfferItemType
     */
    public function setTotalPrice(\StructType\SupplierPriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\SupplierOfferItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
