<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopOverLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container to describe where a Stop Over can be added into an Itinerary. The Stop Over location is tied to the Arrival Port of the referenced Pax Segment (or Pax Leg) referenced and contains the maximum time permitted at that stop.
 * @subpackage Structs
 */
class StopOverLocationType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Dated Operating Legs. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The MaximumDuration
     * Meta information extracted from the WSDL
     * - documentation: Advises the Seller of the maximum time the Passenger can stay at that Stop. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or
     * Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaximumDuration;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Used to store a reference to a given passenger Segment. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * Constructor method for StopOverLocationType
     * @uses StopOverLocationType::setDatedOperatingLegRefID()
     * @uses StopOverLocationType::setMaximumDuration()
     * @uses StopOverLocationType::setPaxSegmentRefID()
     * @param string[] $datedOperatingLegRefID
     * @param string $maximumDuration
     * @param string $paxSegmentRefID
     */
    public function __construct(array $datedOperatingLegRefID = array(), $maximumDuration = null, $paxSegmentRefID = null)
    {
        $this
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setMaximumDuration($maximumDuration)
            ->setPaxSegmentRefID($paxSegmentRefID);
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stopOverLocationTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($stopOverLocationTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($stopOverLocationTypeDatedOperatingLegRefIDItem) ? get_class($stopOverLocationTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($stopOverLocationTypeDatedOperatingLegRefIDItem), var_export($stopOverLocationTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\StopOverLocationType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\StopOverLocationType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get MaximumDuration value
     * @return string|null
     */
    public function getMaximumDuration()
    {
        return $this->MaximumDuration;
    }
    /**
     * Set MaximumDuration value
     * @param string $maximumDuration
     * @return \StructType\StopOverLocationType
     */
    public function setMaximumDuration($maximumDuration = null)
    {
        // validation for constraint: string
        if (!is_null($maximumDuration) && !is_string($maximumDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumDuration, true), gettype($maximumDuration)), __LINE__);
        }
        $this->MaximumDuration = $maximumDuration;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\StopOverLocationType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
}
