<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StationCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The customer's requested Station criteria.
 * @subpackage Structs
 */
class StationCriteriaType extends AbstractStructBase
{
    /**
     * The Station
     * Meta information extracted from the WSDL
     * - documentation: Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off. Those of relevance to the airline industry are identified by an IATA Location
     * Identifier (3 letter location identifier). There are also additional airports without an IATA identifier that may be used in disruption scenarios that will be identified by an ICAO 4 letter code (assigned to every registered airport, military or
     * civil). Business Identifier Fields: - IATA Location Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\StationType[]
     */
    public $Station;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for StationCriteriaType
     * @uses StationCriteriaType::setStation()
     * @uses StationCriteriaType::setPrefLevel()
     * @param \StructType\StationType[] $station
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct(array $station = array(), \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setStation($station)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get Station value
     * @return \StructType\StationType[]
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * This method is responsible for validating the values passed to the setStation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStationForArrayConstraintsFromSetStation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stationCriteriaTypeStationItem) {
            // validation for constraint: itemType
            if (!$stationCriteriaTypeStationItem instanceof \StructType\StationType) {
                $invalidValues[] = is_object($stationCriteriaTypeStationItem) ? get_class($stationCriteriaTypeStationItem) : sprintf('%s(%s)', gettype($stationCriteriaTypeStationItem), var_export($stationCriteriaTypeStationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Station property can only contain items of type \StructType\StationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Station value
     * @throws \InvalidArgumentException
     * @param \StructType\StationType[] $station
     * @return \StructType\StationCriteriaType
     */
    public function setStation(array $station = array())
    {
        // validation for constraint: array
        if ('' !== ($stationArrayErrorMessage = self::validateStationForArrayConstraintsFromSetStation($station))) {
            throw new \InvalidArgumentException($stationArrayErrorMessage, __LINE__);
        }
        $this->Station = $station;
        return $this;
    }
    /**
     * Add item to Station value
     * @throws \InvalidArgumentException
     * @param \StructType\StationType $item
     * @return \StructType\StationCriteriaType
     */
    public function addToStation(\StructType\StationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StationType) {
            throw new \InvalidArgumentException(sprintf('The Station property can only contain items of type \StructType\StationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Station[] = $item;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\StationCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
