<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the Service List Response message.
 * @subpackage Structs
 */
class ServiceListResponseType extends AbstractStructBase
{
    /**
     * The ALaCarteOffer
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ALaCarteOfferType
     */
    public $ALaCarteOffer;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsOfferType[]
     */
    public $PaymentFunctions;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for ServiceListResponseType
     * @uses ServiceListResponseType::setALaCarteOffer()
     * @uses ServiceListResponseType::setDataLists()
     * @uses ServiceListResponseType::setMetadata()
     * @uses ServiceListResponseType::setPaymentFunctions()
     * @uses ServiceListResponseType::setProcessing()
     * @uses ServiceListResponseType::setWarning()
     * @param \StructType\ALaCarteOfferType $aLaCarteOffer
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(\StructType\ALaCarteOfferType $aLaCarteOffer = null, \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, array $paymentFunctions = array(), \StructType\ResponseParametersResponseType $processing = null, array $warning = array())
    {
        $this
            ->setALaCarteOffer($aLaCarteOffer)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setPaymentFunctions($paymentFunctions)
            ->setProcessing($processing)
            ->setWarning($warning);
    }
    /**
     * Get ALaCarteOffer value
     * @return \StructType\ALaCarteOfferType|null
     */
    public function getALaCarteOffer()
    {
        return $this->ALaCarteOffer;
    }
    /**
     * Set ALaCarteOffer value
     * @param \StructType\ALaCarteOfferType $aLaCarteOffer
     * @return \StructType\ServiceListResponseType
     */
    public function setALaCarteOffer(\StructType\ALaCarteOfferType $aLaCarteOffer = null)
    {
        $this->ALaCarteOffer = $aLaCarteOffer;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\ServiceListResponseType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\ServiceListResponseType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsOfferType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListResponseTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$serviceListResponseTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsOfferType) {
                $invalidValues[] = is_object($serviceListResponseTypePaymentFunctionsItem) ? get_class($serviceListResponseTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($serviceListResponseTypePaymentFunctionsItem), var_export($serviceListResponseTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @return \StructType\ServiceListResponseType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType $item
     * @return \StructType\ServiceListResponseType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsOfferType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\ServiceListResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$serviceListResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($serviceListResponseTypeWarningItem) ? get_class($serviceListResponseTypeWarningItem) : sprintf('%s(%s)', gettype($serviceListResponseTypeWarningItem), var_export($serviceListResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\ServiceListResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\ServiceListResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
