<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListOrderRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is request using Order(s)
 * @subpackage Structs
 */
class ServiceListOrderRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A specialized order used in a service list request defined as a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a
     * flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may
     * support non-homogeneity, i.e. each passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceRequestOrderType
     */
    public $Order;
    /**
     * Constructor method for ServiceListOrderRequestType
     * @uses ServiceListOrderRequestType::setOrder()
     * @param \StructType\ServiceRequestOrderType $order
     */
    public function __construct(\StructType\ServiceRequestOrderType $order = null)
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get Order value
     * @return \StructType\ServiceRequestOrderType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\ServiceRequestOrderType $order
     * @return \StructType\ServiceListOrderRequestType
     */
    public function setOrder(\StructType\ServiceRequestOrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
}
