<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a specialized offer used in the context of a Shopping Request. **TO BE MERGED in common type work** Generic offer definition is: A proposal to sell a specific set of products or Services under specific conditions, for a
 * certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main
 * purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a
 * scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
 * @subpackage Structs
 */
class ServiceListOfferType extends AbstractStructBase
{
    /**
     * The OfferID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Offer across several messages. Offer ID facilitates the tracking and verification of individually priced offer(s) selected from the shopping response. Only the Offer IDs of the
     * ORA (Offer Responsible Airline) are returned in shopping responses. Offer ID is unique to each individually priced offer in the shopping response even if the offer price is zero. Offer ID may be specific to individual passengers in the offer, and may
     * be associated with a segment or a journey. The set of Offer IDs returned in a response are referenced by a Shopping Response ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OfferItem
     * Meta information extracted from the WSDL
     * - documentation: This is a specialized offer item used in the context of a Shopping Request. **TO BE MERGED in common type work** Generic offer item definition is: A priced grouping of one or more services within an Offer. The Offer Item assigns a
     * total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceListOfferItemType[]
     */
    public $OfferItem;
    /**
     * Constructor method for ServiceListOfferType
     * @uses ServiceListOfferType::setOfferID()
     * @uses ServiceListOfferType::setOwnerCode()
     * @uses ServiceListOfferType::setOfferItem()
     * @param string $offerID
     * @param string $ownerCode
     * @param \StructType\ServiceListOfferItemType[] $offerItem
     */
    public function __construct($offerID = null, $ownerCode = null, array $offerItem = array())
    {
        $this
            ->setOfferID($offerID)
            ->setOwnerCode($ownerCode)
            ->setOfferItem($offerItem);
    }
    /**
     * Get OfferID value
     * @return string
     */
    public function getOfferID()
    {
        return $this->OfferID;
    }
    /**
     * Set OfferID value
     * @param string $offerID
     * @return \StructType\ServiceListOfferType
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerID, true), gettype($offerID)), __LINE__);
        }
        $this->OfferID = $offerID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ServiceListOfferType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OfferItem value
     * @return \StructType\ServiceListOfferItemType[]|null
     */
    public function getOfferItem()
    {
        return $this->OfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemForArrayConstraintsFromSetOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListOfferTypeOfferItemItem) {
            // validation for constraint: itemType
            if (!$serviceListOfferTypeOfferItemItem instanceof \StructType\ServiceListOfferItemType) {
                $invalidValues[] = is_object($serviceListOfferTypeOfferItemItem) ? get_class($serviceListOfferTypeOfferItemItem) : sprintf('%s(%s)', gettype($serviceListOfferTypeOfferItemItem), var_export($serviceListOfferTypeOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItem property can only contain items of type \StructType\ServiceListOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOfferItemType[] $offerItem
     * @return \StructType\ServiceListOfferType
     */
    public function setOfferItem(array $offerItem = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemArrayErrorMessage = self::validateOfferItemForArrayConstraintsFromSetOfferItem($offerItem))) {
            throw new \InvalidArgumentException($offerItemArrayErrorMessage, __LINE__);
        }
        $this->OfferItem = $offerItem;
        return $this;
    }
    /**
     * Add item to OfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOfferItemType $item
     * @return \StructType\ServiceListOfferType
     */
    public function addToOfferItem(\StructType\ServiceListOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceListOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The OfferItem property can only contain items of type \StructType\ServiceListOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItem[] = $item;
        return $this;
    }
}
