<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDeliveryNotifRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service Delivery Notification Request content for message
 * @subpackage Structs
 */
class ServiceDeliveryNotifRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Delivered Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
     * passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DeliveredOrderType[]
     */
    public $Order;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDeliveryDataListsType
     */
    public $DataLists;
    /**
     * The PaymentProcessingSummary
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingDeliveryResponseSummaryType[]
     */
    public $PaymentProcessingSummary;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Delivered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
     * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveredServiceType
     */
    public $Service;
    /**
     * Constructor method for ServiceDeliveryNotifRequestType
     * @uses ServiceDeliveryNotifRequestType::setOrder()
     * @uses ServiceDeliveryNotifRequestType::setDataLists()
     * @uses ServiceDeliveryNotifRequestType::setPaymentProcessingSummary()
     * @uses ServiceDeliveryNotifRequestType::setService()
     * @param \StructType\DeliveredOrderType[] $order
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType[] $paymentProcessingSummary
     * @param \StructType\DeliveredServiceType $service
     */
    public function __construct(array $order = array(), \StructType\ServiceDeliveryDataListsType $dataLists = null, array $paymentProcessingSummary = array(), \StructType\DeliveredServiceType $service = null)
    {
        $this
            ->setOrder($order)
            ->setDataLists($dataLists)
            ->setPaymentProcessingSummary($paymentProcessingSummary)
            ->setService($service);
    }
    /**
     * Get Order value
     * @return \StructType\DeliveredOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryNotifRequestTypeOrderItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryNotifRequestTypeOrderItem instanceof \StructType\DeliveredOrderType) {
                $invalidValues[] = is_object($serviceDeliveryNotifRequestTypeOrderItem) ? get_class($serviceDeliveryNotifRequestTypeOrderItem) : sprintf('%s(%s)', gettype($serviceDeliveryNotifRequestTypeOrderItem), var_export($serviceDeliveryNotifRequestTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType[] $order
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType $item
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function addToOrder(\StructType\DeliveredOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveredOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\ServiceDeliveryDataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function setDataLists(\StructType\ServiceDeliveryDataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get PaymentProcessingSummary value
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType[]|null
     */
    public function getPaymentProcessingSummary()
    {
        return $this->PaymentProcessingSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentProcessingSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentProcessingSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem instanceof \StructType\PaymentProcessingDeliveryResponseSummaryType) {
                $invalidValues[] = is_object($serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem) ? get_class($serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem) : sprintf('%s(%s)', gettype($serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem), var_export($serviceDeliveryNotifRequestTypePaymentProcessingSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryResponseSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType[] $paymentProcessingSummary
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function setPaymentProcessingSummary(array $paymentProcessingSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentProcessingSummaryArrayErrorMessage = self::validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary($paymentProcessingSummary))) {
            throw new \InvalidArgumentException($paymentProcessingSummaryArrayErrorMessage, __LINE__);
        }
        $this->PaymentProcessingSummary = $paymentProcessingSummary;
        return $this;
    }
    /**
     * Add item to PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType $item
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function addToPaymentProcessingSummary(\StructType\PaymentProcessingDeliveryResponseSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentProcessingDeliveryResponseSummaryType) {
            throw new \InvalidArgumentException(sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryResponseSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentProcessingSummary[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\DeliveredServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\DeliveredServiceType $service
     * @return \StructType\ServiceDeliveryNotifRequestType
     */
    public function setService(\StructType\DeliveredServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
}
