<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDefinitionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Description and characteristics of a non-flight product or service that can be separately sold and delivered. E.g. bag, seat, meal on a flight. Business Identifier Fields: - [Shopping Response] Shopping Response ID - [Carrier]
 * Airline Designator Code - Service Definition ID
 * @subpackage Structs
 */
class ServiceDefinitionType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Service name. Example: Lounge Pass | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The ServiceDefinitionID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service Definition within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDefinitionID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The BookingInstructions
     * Meta information extracted from the WSDL
     * - documentation: Optional service booking instructions to include SSR, OSI and upgrade Method.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingInstructionsType
     */
    public $BookingInstructions;
    /**
     * The DepositTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date by which a deposit must be paid for an order Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositTimeLimitDateTime;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second,
     * and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The RFIC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Code Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) | Enumeration values for Reason for Issuance codes. {codeListAgencyName}PADIS{/codeListAgencyName}
     * {codeListName}Special condition{/codeListName} {codeListIdentifier}4183{/codeListIdentifier} | Additional BDT to specify the reason for issuance code.
     * - base: RFIC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $RFIC;
    /**
     * The RFISC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge) | Enumeration values for Reason for Issuance sub codes. Examples: 0CC (First Checked Bag). 0B1 (In-flight Entertainment). 0BX
     * (Lounge). 0B3 (Meal/ Beverage). 0B5 (Pre-reserved Seat Assignment). 0G6 (Priority Boarding). {codeListAgencyName}ATPCo{/codeListAgencyName} {codeListName}Optional Services Industry Sub Codes{/codeListName} | Additional BDT to specify the reason for
     * issuance sub code.
     * - base: RFISC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFISC;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - documentation: Airline specific service code which can be associated with the Reason for Issuance Sub Code. Sample implementer encoding: XLEG for Extra Leg Room Seat XBAG for Extra Bag | A code is a character string of letters, numbers, special
     * characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCode;
    /**
     * The ServiceDefinitionAssociation
     * Meta information extracted from the WSDL
     * - documentation: Service Definition Association Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics or whether the ServiceDefinition is used as a bundle of further
     * ServiceDefinitions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDefinitionAssociationType
     */
    public $ServiceDefinitionAssociation;
    /**
     * Constructor method for ServiceDefinitionType
     * @uses ServiceDefinitionType::setName()
     * @uses ServiceDefinitionType::setOwnerCode()
     * @uses ServiceDefinitionType::setServiceDefinitionID()
     * @uses ServiceDefinitionType::setAirlineTaxonomy()
     * @uses ServiceDefinitionType::setBilateralTimeLimit()
     * @uses ServiceDefinitionType::setBookingInstructions()
     * @uses ServiceDefinitionType::setDepositTimeLimitDateTime()
     * @uses ServiceDefinitionType::setDesc()
     * @uses ServiceDefinitionType::setNamingTimeLimitDateTime()
     * @uses ServiceDefinitionType::setRFIC()
     * @uses ServiceDefinitionType::setRFISC()
     * @uses ServiceDefinitionType::setServiceCode()
     * @uses ServiceDefinitionType::setServiceDefinitionAssociation()
     * @param string $name
     * @param string $ownerCode
     * @param string $serviceDefinitionID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\BookingInstructionsType $bookingInstructions
     * @param string $depositTimeLimitDateTime
     * @param \StructType\DescType[] $desc
     * @param string $namingTimeLimitDateTime
     * @param string $rFIC
     * @param string $rFISC
     * @param string $serviceCode
     * @param \StructType\ServiceDefinitionAssociationType $serviceDefinitionAssociation
     */
    public function __construct($name = null, $ownerCode = null, $serviceDefinitionID = null, array $airlineTaxonomy = array(), array $bilateralTimeLimit = array(), \StructType\BookingInstructionsType $bookingInstructions = null, $depositTimeLimitDateTime = null, array $desc = array(), $namingTimeLimitDateTime = null, $rFIC = null, $rFISC = null, $serviceCode = null, \StructType\ServiceDefinitionAssociationType $serviceDefinitionAssociation = null)
    {
        $this
            ->setName($name)
            ->setOwnerCode($ownerCode)
            ->setServiceDefinitionID($serviceDefinitionID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setBookingInstructions($bookingInstructions)
            ->setDepositTimeLimitDateTime($depositTimeLimitDateTime)
            ->setDesc($desc)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setRFIC($rFIC)
            ->setRFISC($rFISC)
            ->setServiceCode($serviceCode)
            ->setServiceDefinitionAssociation($serviceDefinitionAssociation);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ServiceDefinitionType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ServiceDefinitionType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get ServiceDefinitionID value
     * @return string
     */
    public function getServiceDefinitionID()
    {
        return $this->ServiceDefinitionID;
    }
    /**
     * Set ServiceDefinitionID value
     * @param string $serviceDefinitionID
     * @return \StructType\ServiceDefinitionType
     */
    public function setServiceDefinitionID($serviceDefinitionID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDefinitionID) && !is_string($serviceDefinitionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDefinitionID, true), gettype($serviceDefinitionID)), __LINE__);
        }
        $this->ServiceDefinitionID = $serviceDefinitionID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDefinitionTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$serviceDefinitionTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($serviceDefinitionTypeAirlineTaxonomyItem) ? get_class($serviceDefinitionTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($serviceDefinitionTypeAirlineTaxonomyItem), var_export($serviceDefinitionTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ServiceDefinitionType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ServiceDefinitionType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDefinitionTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$serviceDefinitionTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($serviceDefinitionTypeBilateralTimeLimitItem) ? get_class($serviceDefinitionTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($serviceDefinitionTypeBilateralTimeLimitItem), var_export($serviceDefinitionTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\ServiceDefinitionType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\ServiceDefinitionType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get BookingInstructions value
     * @return \StructType\BookingInstructionsType|null
     */
    public function getBookingInstructions()
    {
        return $this->BookingInstructions;
    }
    /**
     * Set BookingInstructions value
     * @param \StructType\BookingInstructionsType $bookingInstructions
     * @return \StructType\ServiceDefinitionType
     */
    public function setBookingInstructions(\StructType\BookingInstructionsType $bookingInstructions = null)
    {
        $this->BookingInstructions = $bookingInstructions;
        return $this;
    }
    /**
     * Get DepositTimeLimitDateTime value
     * @return string|null
     */
    public function getDepositTimeLimitDateTime()
    {
        return $this->DepositTimeLimitDateTime;
    }
    /**
     * Set DepositTimeLimitDateTime value
     * @param string $depositTimeLimitDateTime
     * @return \StructType\ServiceDefinitionType
     */
    public function setDepositTimeLimitDateTime($depositTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($depositTimeLimitDateTime) && !is_string($depositTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTimeLimitDateTime, true), gettype($depositTimeLimitDateTime)), __LINE__);
        }
        $this->DepositTimeLimitDateTime = $depositTimeLimitDateTime;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDefinitionTypeDescItem) {
            // validation for constraint: itemType
            if (!$serviceDefinitionTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($serviceDefinitionTypeDescItem) ? get_class($serviceDefinitionTypeDescItem) : sprintf('%s(%s)', gettype($serviceDefinitionTypeDescItem), var_export($serviceDefinitionTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\ServiceDefinitionType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\ServiceDefinitionType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\ServiceDefinitionType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get RFIC value
     * @return string|null
     */
    public function getRFIC()
    {
        return $this->RFIC;
    }
    /**
     * Set RFIC value
     * @param string $rFIC
     * @return \StructType\ServiceDefinitionType
     */
    public function setRFIC($rFIC = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC) && !is_string($rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC, true), gettype($rFIC)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($rFIC) && !preg_match('/[0-9A-Z]{1,3}/', $rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($rFIC, true)), __LINE__);
        }
        $this->RFIC = $rFIC;
        return $this;
    }
    /**
     * Get RFISC value
     * @return string|null
     */
    public function getRFISC()
    {
        return $this->RFISC;
    }
    /**
     * Set RFISC value
     * @param string $rFISC
     * @return \StructType\ServiceDefinitionType
     */
    public function setRFISC($rFISC = null)
    {
        // validation for constraint: string
        if (!is_null($rFISC) && !is_string($rFISC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFISC, true), gettype($rFISC)), __LINE__);
        }
        $this->RFISC = $rFISC;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \StructType\ServiceDefinitionType
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get ServiceDefinitionAssociation value
     * @return \StructType\ServiceDefinitionAssociationType|null
     */
    public function getServiceDefinitionAssociation()
    {
        return $this->ServiceDefinitionAssociation;
    }
    /**
     * Set ServiceDefinitionAssociation value
     * @param \StructType\ServiceDefinitionAssociationType $serviceDefinitionAssociation
     * @return \StructType\ServiceDefinitionType
     */
    public function setServiceDefinitionAssociation(\StructType\ServiceDefinitionAssociationType $serviceDefinitionAssociation = null)
    {
        $this->ServiceDefinitionAssociation = $serviceDefinitionAssociation;
        return $this;
    }
}
