<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellerFollowUpActionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A seller followup action following involuntary change means a subsequent action required to an Order Item after a schedule change.
 * @subpackage Structs
 */
class SellerFollowUpActionType extends AbstractStructBase
{
    /**
     * The ActionInd
     * Meta information extracted from the WSDL
     * - documentation: Action indicator at Order Item level with the following possible value. A 'true' value is returned when the follow-up action has not been completed. Absense of the indicator (or blank) means that there is no pending action. | An
     * indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ActionInd;
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - documentation: Seller FollowUpAction used across Enhanced and Simplified Distribution Standards is defined in IATA codeset SellerFollowUpAction category. | Seller FollowUpAction used across Enhanced and Simplified Distribution Standards is defined
     * in IATA codeset SellerFollowUpAction category. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Seller FollowUpAction, Coded.{/codeListName} {codeListIdentifier}SellerFollowUpAction{/codeListIdentifier} | Seller Followup Action
     * Code
     * - base: SellerFollowupActionCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ActionCode;
    /**
     * The ActionTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: Point in date and time until the seller is allowed to take any FollowUpAction regarding an Order Item after a schedule change. | A date time identifies a date and time of day to various common resolutions: year, month, week, day,
     * hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionTimeLimitDateTime;
    /**
     * The AirlineContactURI
     * Meta information extracted from the WSDL
     * - documentation: Airline Contact URL | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineContactURI;
    /**
     * The ConsequenceOfInactionCode
     * Meta information extracted from the WSDL
     * - documentation: Impact of not taking any action by the seller after a schedule change by the airline. Possible values: o Auto-acceptance by airline o Auto-cancellation by airline | Consequence Of Inaction
     * - base: ConsequenceOfInactionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsequenceOfInactionCode;
    /**
     * Constructor method for SellerFollowUpActionType
     * @uses SellerFollowUpActionType::setActionInd()
     * @uses SellerFollowUpActionType::setActionCode()
     * @uses SellerFollowUpActionType::setActionTimeLimitDateTime()
     * @uses SellerFollowUpActionType::setAirlineContactURI()
     * @uses SellerFollowUpActionType::setConsequenceOfInactionCode()
     * @param bool $actionInd
     * @param string[] $actionCode
     * @param string $actionTimeLimitDateTime
     * @param string $airlineContactURI
     * @param string $consequenceOfInactionCode
     */
    public function __construct($actionInd = null, array $actionCode = array(), $actionTimeLimitDateTime = null, $airlineContactURI = null, $consequenceOfInactionCode = null)
    {
        $this
            ->setActionInd($actionInd)
            ->setActionCode($actionCode)
            ->setActionTimeLimitDateTime($actionTimeLimitDateTime)
            ->setAirlineContactURI($airlineContactURI)
            ->setConsequenceOfInactionCode($consequenceOfInactionCode);
    }
    /**
     * Get ActionInd value
     * @return bool
     */
    public function getActionInd()
    {
        return $this->ActionInd;
    }
    /**
     * Set ActionInd value
     * @param bool $actionInd
     * @return \StructType\SellerFollowUpActionType
     */
    public function setActionInd($actionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionInd) && !is_bool($actionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionInd, true), gettype($actionInd)), __LINE__);
        }
        $this->ActionInd = $actionInd;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string[]|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * This method is responsible for validating the values passed to the setActionCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActionCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionCodeForArrayConstraintsFromSetActionCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sellerFollowUpActionTypeActionCodeItem) {
            // validation for constraint: itemType
            if (!is_string($sellerFollowUpActionTypeActionCodeItem)) {
                $invalidValues[] = is_object($sellerFollowUpActionTypeActionCodeItem) ? get_class($sellerFollowUpActionTypeActionCodeItem) : sprintf('%s(%s)', gettype($sellerFollowUpActionTypeActionCodeItem), var_export($sellerFollowUpActionTypeActionCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActionCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActionCode value
     * @throws \InvalidArgumentException
     * @param string[] $actionCode
     * @return \StructType\SellerFollowUpActionType
     */
    public function setActionCode(array $actionCode = array())
    {
        // validation for constraint: array
        if ('' !== ($actionCodeArrayErrorMessage = self::validateActionCodeForArrayConstraintsFromSetActionCode($actionCode))) {
            throw new \InvalidArgumentException($actionCodeArrayErrorMessage, __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Add item to ActionCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SellerFollowUpActionType
     */
    public function addToActionCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ActionCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActionCode[] = $item;
        return $this;
    }
    /**
     * Get ActionTimeLimitDateTime value
     * @return string|null
     */
    public function getActionTimeLimitDateTime()
    {
        return $this->ActionTimeLimitDateTime;
    }
    /**
     * Set ActionTimeLimitDateTime value
     * @param string $actionTimeLimitDateTime
     * @return \StructType\SellerFollowUpActionType
     */
    public function setActionTimeLimitDateTime($actionTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actionTimeLimitDateTime) && !is_string($actionTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTimeLimitDateTime, true), gettype($actionTimeLimitDateTime)), __LINE__);
        }
        $this->ActionTimeLimitDateTime = $actionTimeLimitDateTime;
        return $this;
    }
    /**
     * Get AirlineContactURI value
     * @return string|null
     */
    public function getAirlineContactURI()
    {
        return $this->AirlineContactURI;
    }
    /**
     * Set AirlineContactURI value
     * @param string $airlineContactURI
     * @return \StructType\SellerFollowUpActionType
     */
    public function setAirlineContactURI($airlineContactURI = null)
    {
        // validation for constraint: string
        if (!is_null($airlineContactURI) && !is_string($airlineContactURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineContactURI, true), gettype($airlineContactURI)), __LINE__);
        }
        $this->AirlineContactURI = $airlineContactURI;
        return $this;
    }
    /**
     * Get ConsequenceOfInactionCode value
     * @return string|null
     */
    public function getConsequenceOfInactionCode()
    {
        return $this->ConsequenceOfInactionCode;
    }
    /**
     * Set ConsequenceOfInactionCode value
     * @param string $consequenceOfInactionCode
     * @return \StructType\SellerFollowUpActionType
     */
    public function setConsequenceOfInactionCode($consequenceOfInactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($consequenceOfInactionCode) && !is_string($consequenceOfInactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consequenceOfInactionCode, true), gettype($consequenceOfInactionCode)), __LINE__);
        }
        $this->ConsequenceOfInactionCode = $consequenceOfInactionCode;
        return $this;
    }
}
