<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedSeatType StructType
 * Meta information extracted from the WSDL
 * - documentation: Selection of specific seat location, as provided in seat availability messages. When used, only a single Passenger must be referenced for a single Segment.
 * @subpackage Structs
 */
class SelectedSeatType extends AbstractStructBase
{
    /**
     * The ColumnID
     * Meta information extracted from the WSDL
     * - documentation: Seat column to identify a particular seat position on an aircraft. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ColumnID;
    /**
     * The SeatRowNumber
     * Meta information extracted from the WSDL
     * - documentation: Seat Row number. Example: 2 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SeatRowNumber;
    /**
     * Constructor method for SelectedSeatType
     * @uses SelectedSeatType::setColumnID()
     * @uses SelectedSeatType::setSeatRowNumber()
     * @param string $columnID
     * @param float $seatRowNumber
     */
    public function __construct($columnID = null, $seatRowNumber = null)
    {
        $this
            ->setColumnID($columnID)
            ->setSeatRowNumber($seatRowNumber);
    }
    /**
     * Get ColumnID value
     * @return string
     */
    public function getColumnID()
    {
        return $this->ColumnID;
    }
    /**
     * Set ColumnID value
     * @param string $columnID
     * @return \StructType\SelectedSeatType
     */
    public function setColumnID($columnID = null)
    {
        // validation for constraint: string
        if (!is_null($columnID) && !is_string($columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnID, true), gettype($columnID)), __LINE__);
        }
        $this->ColumnID = $columnID;
        return $this;
    }
    /**
     * Get SeatRowNumber value
     * @return float
     */
    public function getSeatRowNumber()
    {
        return $this->SeatRowNumber;
    }
    /**
     * Set SeatRowNumber value
     * @param float $seatRowNumber
     * @return \StructType\SelectedSeatType
     */
    public function setSeatRowNumber($seatRowNumber = null)
    {
        // validation for constraint: float
        if (!is_null($seatRowNumber) && !(is_float($seatRowNumber) || is_numeric($seatRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($seatRowNumber, true), gettype($seatRowNumber)), __LINE__);
        }
        $this->SeatRowNumber = $seatRowNumber;
        return $this;
    }
}
