<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs). Each Offer
 * selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and 'a-la-carte' Offers
 * would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
 * @subpackage Structs
 */
class SelectedOfferType extends AbstractStructBase
{
    /**
     * The OfferRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response. | An identifier is a character string used to uniquely identify one instance of an object
     * within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Designator of Airline that owns/ assigned these IDs. Examples: BA | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution
     * 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO
     * Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The SelectedOfferItem
     * Meta information extracted from the WSDL
     * - documentation: OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items
     * or different seat locations. As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems.
     * Optional OfferItems may then be appended as further items selected by the Passenger. OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem
     * referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous
     * shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItem's associations (to passengers and/or flight segments).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SelectedOfferItemType[]
     */
    public $SelectedOfferItem;
    /**
     * Constructor method for SelectedOfferType
     * @uses SelectedOfferType::setOfferRefID()
     * @uses SelectedOfferType::setOwnerCode()
     * @uses SelectedOfferType::setSelectedOfferItem()
     * @param string $offerRefID
     * @param string $ownerCode
     * @param \StructType\SelectedOfferItemType[] $selectedOfferItem
     */
    public function __construct($offerRefID = null, $ownerCode = null, array $selectedOfferItem = array())
    {
        $this
            ->setOfferRefID($offerRefID)
            ->setOwnerCode($ownerCode)
            ->setSelectedOfferItem($selectedOfferItem);
    }
    /**
     * Get OfferRefID value
     * @return string
     */
    public function getOfferRefID()
    {
        return $this->OfferRefID;
    }
    /**
     * Set OfferRefID value
     * @param string $offerRefID
     * @return \StructType\SelectedOfferType
     */
    public function setOfferRefID($offerRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerRefID) && !is_string($offerRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerRefID, true), gettype($offerRefID)), __LINE__);
        }
        $this->OfferRefID = $offerRefID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SelectedOfferType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get SelectedOfferItem value
     * @return \StructType\SelectedOfferItemType[]
     */
    public function getSelectedOfferItem()
    {
        return $this->SelectedOfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOfferItemForArrayConstraintsFromSetSelectedOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedOfferTypeSelectedOfferItemItem) {
            // validation for constraint: itemType
            if (!$selectedOfferTypeSelectedOfferItemItem instanceof \StructType\SelectedOfferItemType) {
                $invalidValues[] = is_object($selectedOfferTypeSelectedOfferItemItem) ? get_class($selectedOfferTypeSelectedOfferItemItem) : sprintf('%s(%s)', gettype($selectedOfferTypeSelectedOfferItemItem), var_export($selectedOfferTypeSelectedOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOfferItem property can only contain items of type \StructType\SelectedOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferItemType[] $selectedOfferItem
     * @return \StructType\SelectedOfferType
     */
    public function setSelectedOfferItem(array $selectedOfferItem = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOfferItemArrayErrorMessage = self::validateSelectedOfferItemForArrayConstraintsFromSetSelectedOfferItem($selectedOfferItem))) {
            throw new \InvalidArgumentException($selectedOfferItemArrayErrorMessage, __LINE__);
        }
        $this->SelectedOfferItem = $selectedOfferItem;
        return $this;
    }
    /**
     * Add item to SelectedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferItemType $item
     * @return \StructType\SelectedOfferType
     */
    public function addToSelectedOfferItem(\StructType\SelectedOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOfferItem property can only contain items of type \StructType\SelectedOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOfferItem[] = $item;
        return $this;
    }
}
