<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedOfferListType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of Selected Offer's
 * @subpackage Structs
 */
class SelectedOfferListType extends AbstractStructBase
{
    /**
     * The SelectedOffer
     * Meta information extracted from the WSDL
     * - documentation: Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs). Each Offer
     * selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and 'a-la-carte' Offers
     * would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SelectedOfferType[]
     */
    public $SelectedOffer;
    /**
     * Constructor method for SelectedOfferListType
     * @uses SelectedOfferListType::setSelectedOffer()
     * @param \StructType\SelectedOfferType[] $selectedOffer
     */
    public function __construct(array $selectedOffer = array())
    {
        $this
            ->setSelectedOffer($selectedOffer);
    }
    /**
     * Get SelectedOffer value
     * @return \StructType\SelectedOfferType[]
     */
    public function getSelectedOffer()
    {
        return $this->SelectedOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOfferForArrayConstraintsFromSetSelectedOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedOfferListTypeSelectedOfferItem) {
            // validation for constraint: itemType
            if (!$selectedOfferListTypeSelectedOfferItem instanceof \StructType\SelectedOfferType) {
                $invalidValues[] = is_object($selectedOfferListTypeSelectedOfferItem) ? get_class($selectedOfferListTypeSelectedOfferItem) : sprintf('%s(%s)', gettype($selectedOfferListTypeSelectedOfferItem), var_export($selectedOfferListTypeSelectedOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOffer property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType[] $selectedOffer
     * @return \StructType\SelectedOfferListType
     */
    public function setSelectedOffer(array $selectedOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOfferArrayErrorMessage = self::validateSelectedOfferForArrayConstraintsFromSetSelectedOffer($selectedOffer))) {
            throw new \InvalidArgumentException($selectedOfferArrayErrorMessage, __LINE__);
        }
        $this->SelectedOffer = $selectedOffer;
        return $this;
    }
    /**
     * Add item to SelectedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType $item
     * @return \StructType\SelectedOfferListType
     */
    public function addToSelectedOffer(\StructType\SelectedOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOfferType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOffer property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOffer[] = $item;
        return $this;
    }
}
