<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filters results based on segment information.
 * @subpackage Structs
 */
class SegmentFilterCriteriaType extends AbstractStructBase
{
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: Flight arrival information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ArrivalFilterCriteriaType
     */
    public $Arrival;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: Flight departure information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DepFilterCriteriaType
     */
    public $Dep;
    /**
     * Constructor method for SegmentFilterCriteriaType
     * @uses SegmentFilterCriteriaType::setArrival()
     * @uses SegmentFilterCriteriaType::setDep()
     * @param \StructType\ArrivalFilterCriteriaType $arrival
     * @param \StructType\DepFilterCriteriaType $dep
     */
    public function __construct(\StructType\ArrivalFilterCriteriaType $arrival = null, \StructType\DepFilterCriteriaType $dep = null)
    {
        $this
            ->setArrival($arrival)
            ->setDep($dep);
    }
    /**
     * Get Arrival value
     * @return \StructType\ArrivalFilterCriteriaType
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\ArrivalFilterCriteriaType $arrival
     * @return \StructType\SegmentFilterCriteriaType
     */
    public function setArrival(\StructType\ArrivalFilterCriteriaType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\DepFilterCriteriaType
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\DepFilterCriteriaType $dep
     * @return \StructType\SegmentFilterCriteriaType
     */
    public function setDep(\StructType\DepFilterCriteriaType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
}
