<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment StructType
 * Meta information extracted from the WSDL
 * - documentation: Segment information group
 * @subpackage Structs
 */
class Segment extends AbstractStructBase
{
    /**
     * The Departure
     * Meta information extracted from the WSDL
     * - ref: Departure
     * @var \StructType\Departure
     */
    public $Departure;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - ref: Arrival
     * @var \StructType\Arrival
     */
    public $Arrival;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - ref: Carrier
     * @var \StructType\Carrier
     */
    public $Carrier;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OperatingCarrier
     * @var \StructType\OperatingCarrier
     */
    public $OperatingCarrier;
    /**
     * The OperatingCarrierDisclosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OperatingCarrierDisclosure
     * @var \StructType\OperatingCarrierDisclosure
     */
    public $OperatingCarrierDisclosure;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - ref: Equipment
     * @var \StructType\Equipment
     */
    public $Equipment;
    /**
     * The NumberOfStops
     * Meta information extracted from the WSDL
     * - documentation: Number of stops. Example: 0
     * - base: xs:integer
     * - maxInclusive: 9
     * - minInclusive: 0
     * - minOccurs: 0
     * - ref: NumberOfStops
     * @var int
     */
    public $NumberOfStops;
    /**
     * The StopInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopInformation
     * @var \StructType\StopInformation
     */
    public $StopInformation;
    /**
     * The Meals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Meals
     * @var string
     */
    public $Meals;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Frequency
     * @var string
     */
    public $Frequency;
    /**
     * The FlightDuration
     * Meta information extracted from the WSDL
     * - documentation: Segment total flying time. Example: 01:30
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9][0-9]:[0-5][0-9]
     * - ref: FlightDuration
     * @var string
     */
    public $FlightDuration;
    /**
     * The OnTimeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OnTimeInfo
     * @var string
     */
    public $OnTimeInfo;
    /**
     * The ElectronicTicketing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ElectronicTicketing
     * @var string
     */
    public $ElectronicTicketing;
    /**
     * The Ticketless
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Ticketless
     * @var string
     */
    public $Ticketless;
    /**
     * The InstantPurchase
     * Meta information extracted from the WSDL
     * - documentation: Instant Purchase indicator. For values please refer to FLX Codeset documentation.Example: CC
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * - ref: InstantPurchase
     * @var string
     */
    public $InstantPurchase;
    /**
     * The TrafficRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TrafficRestrictions
     * @var string
     */
    public $TrafficRestrictions;
    /**
     * The LegMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: LegMiles
     * @var string
     */
    public $LegMiles;
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Classes
     * @var \StructType\Classes
     */
    public $Classes;
    /**
     * The ChangeOfAirport
     * @var string
     */
    public $ChangeOfAirport;
    /**
     * The CnxxIndicator
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $CnxxIndicator;
    /**
     * The SellIndicator
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $SellIndicator;
    /**
     * The SecureFlight
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SecureFlight;
    /**
     * The MarriedSegment
     * @var string
     */
    public $MarriedSegment;
    /**
     * Constructor method for Segment
     * @uses Segment::setDeparture()
     * @uses Segment::setArrival()
     * @uses Segment::setCarrier()
     * @uses Segment::setOperatingCarrier()
     * @uses Segment::setOperatingCarrierDisclosure()
     * @uses Segment::setEquipment()
     * @uses Segment::setNumberOfStops()
     * @uses Segment::setStopInformation()
     * @uses Segment::setMeals()
     * @uses Segment::setFrequency()
     * @uses Segment::setFlightDuration()
     * @uses Segment::setOnTimeInfo()
     * @uses Segment::setElectronicTicketing()
     * @uses Segment::setTicketless()
     * @uses Segment::setInstantPurchase()
     * @uses Segment::setTrafficRestrictions()
     * @uses Segment::setLegMiles()
     * @uses Segment::setClasses()
     * @uses Segment::setChangeOfAirport()
     * @uses Segment::setCnxxIndicator()
     * @uses Segment::setSellIndicator()
     * @uses Segment::setSecureFlight()
     * @uses Segment::setMarriedSegment()
     * @param \StructType\Departure $departure
     * @param \StructType\Arrival $arrival
     * @param \StructType\Carrier $carrier
     * @param \StructType\OperatingCarrier $operatingCarrier
     * @param \StructType\OperatingCarrierDisclosure $operatingCarrierDisclosure
     * @param \StructType\Equipment $equipment
     * @param int $numberOfStops
     * @param \StructType\StopInformation $stopInformation
     * @param string $meals
     * @param string $frequency
     * @param string $flightDuration
     * @param string $onTimeInfo
     * @param string $electronicTicketing
     * @param string $ticketless
     * @param string $instantPurchase
     * @param string $trafficRestrictions
     * @param string $legMiles
     * @param \StructType\Classes $classes
     * @param string $changeOfAirport
     * @param string $cnxxIndicator
     * @param string $sellIndicator
     * @param string $secureFlight
     * @param string $marriedSegment
     */
    public function __construct(\StructType\Departure $departure = null, \StructType\Arrival $arrival = null, \StructType\Carrier $carrier = null, \StructType\OperatingCarrier $operatingCarrier = null, \StructType\OperatingCarrierDisclosure $operatingCarrierDisclosure = null, \StructType\Equipment $equipment = null, $numberOfStops = null, \StructType\StopInformation $stopInformation = null, $meals = null, $frequency = null, $flightDuration = null, $onTimeInfo = null, $electronicTicketing = null, $ticketless = null, $instantPurchase = null, $trafficRestrictions = null, $legMiles = null, \StructType\Classes $classes = null, $changeOfAirport = null, $cnxxIndicator = null, $sellIndicator = null, $secureFlight = null, $marriedSegment = null)
    {
        $this
            ->setDeparture($departure)
            ->setArrival($arrival)
            ->setCarrier($carrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setOperatingCarrierDisclosure($operatingCarrierDisclosure)
            ->setEquipment($equipment)
            ->setNumberOfStops($numberOfStops)
            ->setStopInformation($stopInformation)
            ->setMeals($meals)
            ->setFrequency($frequency)
            ->setFlightDuration($flightDuration)
            ->setOnTimeInfo($onTimeInfo)
            ->setElectronicTicketing($electronicTicketing)
            ->setTicketless($ticketless)
            ->setInstantPurchase($instantPurchase)
            ->setTrafficRestrictions($trafficRestrictions)
            ->setLegMiles($legMiles)
            ->setClasses($classes)
            ->setChangeOfAirport($changeOfAirport)
            ->setCnxxIndicator($cnxxIndicator)
            ->setSellIndicator($sellIndicator)
            ->setSecureFlight($secureFlight)
            ->setMarriedSegment($marriedSegment);
    }
    /**
     * Get Departure value
     * @return \StructType\Departure|null
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param \StructType\Departure $departure
     * @return \StructType\Segment
     */
    public function setDeparture(\StructType\Departure $departure = null)
    {
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get Arrival value
     * @return \StructType\Arrival|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\Arrival $arrival
     * @return \StructType\Segment
     */
    public function setArrival(\StructType\Arrival $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \StructType\Carrier|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\Carrier $carrier
     * @return \StructType\Segment
     */
    public function setCarrier(\StructType\Carrier $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return \StructType\OperatingCarrier|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param \StructType\OperatingCarrier $operatingCarrier
     * @return \StructType\Segment
     */
    public function setOperatingCarrier(\StructType\OperatingCarrier $operatingCarrier = null)
    {
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrierDisclosure value
     * @return \StructType\OperatingCarrierDisclosure|null
     */
    public function getOperatingCarrierDisclosure()
    {
        return $this->OperatingCarrierDisclosure;
    }
    /**
     * Set OperatingCarrierDisclosure value
     * @param \StructType\OperatingCarrierDisclosure $operatingCarrierDisclosure
     * @return \StructType\Segment
     */
    public function setOperatingCarrierDisclosure(\StructType\OperatingCarrierDisclosure $operatingCarrierDisclosure = null)
    {
        $this->OperatingCarrierDisclosure = $operatingCarrierDisclosure;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \StructType\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\Equipment $equipment
     * @return \StructType\Segment
     */
    public function setEquipment(\StructType\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get NumberOfStops value
     * @return int|null
     */
    public function getNumberOfStops()
    {
        return $this->NumberOfStops;
    }
    /**
     * Set NumberOfStops value
     * @param int $numberOfStops
     * @return \StructType\Segment
     */
    public function setNumberOfStops($numberOfStops = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfStops) && !(is_int($numberOfStops) || ctype_digit($numberOfStops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfStops, true), gettype($numberOfStops)), __LINE__);
        }
        // validation for constraint: maxInclusive(9)
        if (!is_null($numberOfStops) && $numberOfStops > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9', var_export($numberOfStops, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($numberOfStops) && $numberOfStops < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($numberOfStops, true)), __LINE__);
        }
        $this->NumberOfStops = $numberOfStops;
        return $this;
    }
    /**
     * Get StopInformation value
     * @return \StructType\StopInformation|null
     */
    public function getStopInformation()
    {
        return $this->StopInformation;
    }
    /**
     * Set StopInformation value
     * @param \StructType\StopInformation $stopInformation
     * @return \StructType\Segment
     */
    public function setStopInformation(\StructType\StopInformation $stopInformation = null)
    {
        $this->StopInformation = $stopInformation;
        return $this;
    }
    /**
     * Get Meals value
     * @return string|null
     */
    public function getMeals()
    {
        return $this->Meals;
    }
    /**
     * Set Meals value
     * @uses \EnumType\Meals::valueIsValid()
     * @uses \EnumType\Meals::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $meals
     * @return \StructType\Segment
     */
    public function setMeals($meals = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Meals::valueIsValid($meals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Meals', is_array($meals) ? implode(', ', $meals) : var_export($meals, true), implode(', ', \EnumType\Meals::getValidValues())), __LINE__);
        }
        $this->Meals = $meals;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\Segment
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get FlightDuration value
     * @return string|null
     */
    public function getFlightDuration()
    {
        return $this->FlightDuration;
    }
    /**
     * Set FlightDuration value
     * @param string $flightDuration
     * @return \StructType\Segment
     */
    public function setFlightDuration($flightDuration = null)
    {
        // validation for constraint: string
        if (!is_null($flightDuration) && !is_string($flightDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDuration, true), gettype($flightDuration)), __LINE__);
        }
        // validation for constraint: pattern([0-9][0-9]:[0-5][0-9])
        if (!is_null($flightDuration) && !preg_match('/[0-9][0-9]:[0-5][0-9]/', $flightDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9][0-9]:[0-5][0-9]', var_export($flightDuration, true)), __LINE__);
        }
        $this->FlightDuration = $flightDuration;
        return $this;
    }
    /**
     * Get OnTimeInfo value
     * @return string|null
     */
    public function getOnTimeInfo()
    {
        return $this->OnTimeInfo;
    }
    /**
     * Set OnTimeInfo value
     * @uses \EnumType\OnTimeInfo::valueIsValid()
     * @uses \EnumType\OnTimeInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $onTimeInfo
     * @return \StructType\Segment
     */
    public function setOnTimeInfo($onTimeInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OnTimeInfo::valueIsValid($onTimeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OnTimeInfo', is_array($onTimeInfo) ? implode(', ', $onTimeInfo) : var_export($onTimeInfo, true), implode(', ', \EnumType\OnTimeInfo::getValidValues())), __LINE__);
        }
        $this->OnTimeInfo = $onTimeInfo;
        return $this;
    }
    /**
     * Get ElectronicTicketing value
     * @return string|null
     */
    public function getElectronicTicketing()
    {
        return $this->ElectronicTicketing;
    }
    /**
     * Set ElectronicTicketing value
     * @uses \EnumType\ElectronicTicketing::valueIsValid()
     * @uses \EnumType\ElectronicTicketing::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $electronicTicketing
     * @return \StructType\Segment
     */
    public function setElectronicTicketing($electronicTicketing = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ElectronicTicketing::valueIsValid($electronicTicketing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ElectronicTicketing', is_array($electronicTicketing) ? implode(', ', $electronicTicketing) : var_export($electronicTicketing, true), implode(', ', \EnumType\ElectronicTicketing::getValidValues())), __LINE__);
        }
        $this->ElectronicTicketing = $electronicTicketing;
        return $this;
    }
    /**
     * Get Ticketless value
     * @return string|null
     */
    public function getTicketless()
    {
        return $this->Ticketless;
    }
    /**
     * Set Ticketless value
     * @uses \EnumType\Ticketless::valueIsValid()
     * @uses \EnumType\Ticketless::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketless
     * @return \StructType\Segment
     */
    public function setTicketless($ticketless = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Ticketless::valueIsValid($ticketless)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Ticketless', is_array($ticketless) ? implode(', ', $ticketless) : var_export($ticketless, true), implode(', ', \EnumType\Ticketless::getValidValues())), __LINE__);
        }
        $this->Ticketless = $ticketless;
        return $this;
    }
    /**
     * Get InstantPurchase value
     * @return string|null
     */
    public function getInstantPurchase()
    {
        return $this->InstantPurchase;
    }
    /**
     * Set InstantPurchase value
     * @param string $instantPurchase
     * @return \StructType\Segment
     */
    public function setInstantPurchase($instantPurchase = null)
    {
        // validation for constraint: string
        if (!is_null($instantPurchase) && !is_string($instantPurchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instantPurchase, true), gettype($instantPurchase)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($instantPurchase) && mb_strlen($instantPurchase) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($instantPurchase)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($instantPurchase) && mb_strlen($instantPurchase) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($instantPurchase)), __LINE__);
        }
        $this->InstantPurchase = $instantPurchase;
        return $this;
    }
    /**
     * Get TrafficRestrictions value
     * @return string|null
     */
    public function getTrafficRestrictions()
    {
        return $this->TrafficRestrictions;
    }
    /**
     * Set TrafficRestrictions value
     * @uses \EnumType\TrafficRestrictions::valueIsValid()
     * @uses \EnumType\TrafficRestrictions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficRestrictions
     * @return \StructType\Segment
     */
    public function setTrafficRestrictions($trafficRestrictions = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficRestrictions::valueIsValid($trafficRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TrafficRestrictions', is_array($trafficRestrictions) ? implode(', ', $trafficRestrictions) : var_export($trafficRestrictions, true), implode(', ', \EnumType\TrafficRestrictions::getValidValues())), __LINE__);
        }
        $this->TrafficRestrictions = $trafficRestrictions;
        return $this;
    }
    /**
     * Get LegMiles value
     * @return string|null
     */
    public function getLegMiles()
    {
        return $this->LegMiles;
    }
    /**
     * Set LegMiles value
     * @param string $legMiles
     * @return \StructType\Segment
     */
    public function setLegMiles($legMiles = null)
    {
        // validation for constraint: string
        if (!is_null($legMiles) && !is_string($legMiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legMiles, true), gettype($legMiles)), __LINE__);
        }
        $this->LegMiles = $legMiles;
        return $this;
    }
    /**
     * Get Classes value
     * @return \StructType\Classes|null
     */
    public function getClasses()
    {
        return $this->Classes;
    }
    /**
     * Set Classes value
     * @param \StructType\Classes $classes
     * @return \StructType\Segment
     */
    public function setClasses(\StructType\Classes $classes = null)
    {
        $this->Classes = $classes;
        return $this;
    }
    /**
     * Get ChangeOfAirport value
     * @return string|null
     */
    public function getChangeOfAirport()
    {
        return $this->ChangeOfAirport;
    }
    /**
     * Set ChangeOfAirport value
     * @param string $changeOfAirport
     * @return \StructType\Segment
     */
    public function setChangeOfAirport($changeOfAirport = null)
    {
        // validation for constraint: string
        if (!is_null($changeOfAirport) && !is_string($changeOfAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeOfAirport, true), gettype($changeOfAirport)), __LINE__);
        }
        $this->ChangeOfAirport = $changeOfAirport;
        return $this;
    }
    /**
     * Get CnxxIndicator value
     * @return string|null
     */
    public function getCnxxIndicator()
    {
        return $this->CnxxIndicator;
    }
    /**
     * Set CnxxIndicator value
     * @param string $cnxxIndicator
     * @return \StructType\Segment
     */
    public function setCnxxIndicator($cnxxIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($cnxxIndicator) && !is_string($cnxxIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnxxIndicator, true), gettype($cnxxIndicator)), __LINE__);
        }
        $this->CnxxIndicator = $cnxxIndicator;
        return $this;
    }
    /**
     * Get SellIndicator value
     * @return string|null
     */
    public function getSellIndicator()
    {
        return $this->SellIndicator;
    }
    /**
     * Set SellIndicator value
     * @param string $sellIndicator
     * @return \StructType\Segment
     */
    public function setSellIndicator($sellIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($sellIndicator) && !is_string($sellIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellIndicator, true), gettype($sellIndicator)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sellIndicator) && mb_strlen($sellIndicator) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sellIndicator)), __LINE__);
        }
        $this->SellIndicator = $sellIndicator;
        return $this;
    }
    /**
     * Get SecureFlight value
     * @return string|null
     */
    public function getSecureFlight()
    {
        return $this->SecureFlight;
    }
    /**
     * Set SecureFlight value
     * @param string $secureFlight
     * @return \StructType\Segment
     */
    public function setSecureFlight($secureFlight = null)
    {
        // validation for constraint: string
        if (!is_null($secureFlight) && !is_string($secureFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureFlight, true), gettype($secureFlight)), __LINE__);
        }
        $this->SecureFlight = $secureFlight;
        return $this;
    }
    /**
     * Get MarriedSegment value
     * @return string|null
     */
    public function getMarriedSegment()
    {
        return $this->MarriedSegment;
    }
    /**
     * Set MarriedSegment value
     * @param string $marriedSegment
     * @return \StructType\Segment
     */
    public function setMarriedSegment($marriedSegment = null)
    {
        // validation for constraint: string
        if (!is_null($marriedSegment) && !is_string($marriedSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marriedSegment, true), gettype($marriedSegment)), __LINE__);
        }
        $this->MarriedSegment = $marriedSegment;
        return $this;
    }
}
