<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRowType StructType
 * Meta information extracted from the WSDL
 * - documentation: Row of passenger seats located in the cabin. Business Identifier Fields: - [Aircraft Group Configuration] (All identifying fields) - [Deck] Deck Code - [Cabin Section] Cabin Section ID - Row Number
 * @subpackage Structs
 */
class SeatRowType extends AbstractStructBase
{
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Ordinal number identifying a seat row in an aircraft. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 1
     * @var int
     */
    public $RowNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AvailableSeatType[]
     */
    public $Seat;
    /**
     * The RowCharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Information and characteristics applying to a row of Passenger Seats (examples: XC - Exit Row, N - No Smoking Row, etc.). PADIS 9864 | Row characteristic. Examples: A (Extra Leg Room) B (Buffer Row) MV (Row With Movie Screen)
     * Encoding Scheme: IATA PADIS Code List for data element 9864 - Row Characteristic {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Row Characteristic{/codeListName} {codeListIdentifier}9864{/codeListIdentifier} | Additional BDT to specify
     * the seat row characteristics code.
     * - base: SeatRowCharacteristicsCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RowCharacteristicCode;
    /**
     * Constructor method for SeatRowType
     * @uses SeatRowType::setRowNumber()
     * @uses SeatRowType::setSeat()
     * @uses SeatRowType::setRowCharacteristicCode()
     * @param int $rowNumber
     * @param \StructType\AvailableSeatType[] $seat
     * @param string[] $rowCharacteristicCode
     */
    public function __construct($rowNumber = null, array $seat = array(), array $rowCharacteristicCode = array())
    {
        $this
            ->setRowNumber($rowNumber)
            ->setSeat($seat)
            ->setRowCharacteristicCode($rowCharacteristicCode);
    }
    /**
     * Get RowNumber value
     * @return int
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatRowType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rowNumber) && $rowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rowNumber, true)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seat value
     * @return \StructType\AvailableSeatType[]
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * This method is responsible for validating the values passed to the setSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatForArrayConstraintsFromSetSeat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRowTypeSeatItem) {
            // validation for constraint: itemType
            if (!$seatRowTypeSeatItem instanceof \StructType\AvailableSeatType) {
                $invalidValues[] = is_object($seatRowTypeSeatItem) ? get_class($seatRowTypeSeatItem) : sprintf('%s(%s)', gettype($seatRowTypeSeatItem), var_export($seatRowTypeSeatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Seat property can only contain items of type \StructType\AvailableSeatType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Seat value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableSeatType[] $seat
     * @return \StructType\SeatRowType
     */
    public function setSeat(array $seat = array())
    {
        // validation for constraint: array
        if ('' !== ($seatArrayErrorMessage = self::validateSeatForArrayConstraintsFromSetSeat($seat))) {
            throw new \InvalidArgumentException($seatArrayErrorMessage, __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Add item to Seat value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableSeatType $item
     * @return \StructType\SeatRowType
     */
    public function addToSeat(\StructType\AvailableSeatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AvailableSeatType) {
            throw new \InvalidArgumentException(sprintf('The Seat property can only contain items of type \StructType\AvailableSeatType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Seat[] = $item;
        return $this;
    }
    /**
     * Get RowCharacteristicCode value
     * @return string[]|null
     */
    public function getRowCharacteristicCode()
    {
        return $this->RowCharacteristicCode;
    }
    /**
     * This method is responsible for validating the values passed to the setRowCharacteristicCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRowCharacteristicCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowCharacteristicCodeForArrayConstraintsFromSetRowCharacteristicCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRowTypeRowCharacteristicCodeItem) {
            // validation for constraint: itemType
            if (!is_string($seatRowTypeRowCharacteristicCodeItem)) {
                $invalidValues[] = is_object($seatRowTypeRowCharacteristicCodeItem) ? get_class($seatRowTypeRowCharacteristicCodeItem) : sprintf('%s(%s)', gettype($seatRowTypeRowCharacteristicCodeItem), var_export($seatRowTypeRowCharacteristicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RowCharacteristicCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RowCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string[] $rowCharacteristicCode
     * @return \StructType\SeatRowType
     */
    public function setRowCharacteristicCode(array $rowCharacteristicCode = array())
    {
        // validation for constraint: array
        if ('' !== ($rowCharacteristicCodeArrayErrorMessage = self::validateRowCharacteristicCodeForArrayConstraintsFromSetRowCharacteristicCode($rowCharacteristicCode))) {
            throw new \InvalidArgumentException($rowCharacteristicCodeArrayErrorMessage, __LINE__);
        }
        $this->RowCharacteristicCode = $rowCharacteristicCode;
        return $this;
    }
    /**
     * Add item to RowCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatRowType
     */
    public function addToRowCharacteristicCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RowCharacteristicCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RowCharacteristicCode[] = $item;
        return $this;
    }
}
