<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatProfileCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline defined group of seats sharing common characteristics.
 * @subpackage Structs
 */
class SeatProfileCriteriaType extends AbstractStructBase
{
    /**
     * The SeatCharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825. | Refers to aircraft seat characteristic codes e.g. A (Aisle seat), E (Exit and emergency exit). See PADIS
     * code list 9825. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat characteristic,coded{/codeListName} {codeListIdentifier}9825{/codeListIdentifier} | Specifies a Seat Characteristic code.
     * - base: SeatCharacteristicCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatCharacteristicCode;
    /**
     * Constructor method for SeatProfileCriteriaType
     * @uses SeatProfileCriteriaType::setSeatCharacteristicCode()
     * @param string[] $seatCharacteristicCode
     */
    public function __construct(array $seatCharacteristicCode = array())
    {
        $this
            ->setSeatCharacteristicCode($seatCharacteristicCode);
    }
    /**
     * Get SeatCharacteristicCode value
     * @return string[]|null
     */
    public function getSeatCharacteristicCode()
    {
        return $this->SeatCharacteristicCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCharacteristicCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCharacteristicCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileCriteriaTypeSeatCharacteristicCodeItem) {
            // validation for constraint: itemType
            if (!is_string($seatProfileCriteriaTypeSeatCharacteristicCodeItem)) {
                $invalidValues[] = is_object($seatProfileCriteriaTypeSeatCharacteristicCodeItem) ? get_class($seatProfileCriteriaTypeSeatCharacteristicCodeItem) : sprintf('%s(%s)', gettype($seatProfileCriteriaTypeSeatCharacteristicCodeItem), var_export($seatProfileCriteriaTypeSeatCharacteristicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string[] $seatCharacteristicCode
     * @return \StructType\SeatProfileCriteriaType
     */
    public function setSeatCharacteristicCode(array $seatCharacteristicCode = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCharacteristicCodeArrayErrorMessage = self::validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode($seatCharacteristicCode))) {
            throw new \InvalidArgumentException($seatCharacteristicCodeArrayErrorMessage, __LINE__);
        }
        $this->SeatCharacteristicCode = $seatCharacteristicCode;
        return $this;
    }
    /**
     * Add item to SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatProfileCriteriaType
     */
    public function addToSeatCharacteristicCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCharacteristicCode[] = $item;
        return $this;
    }
}
