<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapType StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns a list of cabins and the seats within in. This information can be used by the Seller to render a graphical Seat Map.
 * @subpackage Structs
 */
class SeatMapType extends AbstractStructBase
{
    /**
     * The CabinCompartment
     * Meta information extracted from the WSDL
     * - documentation: A physical aircraft compartment where passenger seats are installed, classified by a given Cabin Type. These compartments are typically defined based on fare paid or facilities and services offered.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\CabinCompartmentType[]
     */
    public $CabinCompartment;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Passenger Segment ID from this message or from wiithin the SeatAvailability request. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is
     * managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Leg ID from wiithin the SeatAvailability request. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * Constructor method for SeatMapType
     * @uses SeatMapType::setCabinCompartment()
     * @uses SeatMapType::setPaxSegmentRefID()
     * @uses SeatMapType::setDatedOperatingLegRefID()
     * @param \StructType\CabinCompartmentType[] $cabinCompartment
     * @param string $paxSegmentRefID
     * @param string[] $datedOperatingLegRefID
     */
    public function __construct(array $cabinCompartment = array(), $paxSegmentRefID = null, array $datedOperatingLegRefID = array())
    {
        $this
            ->setCabinCompartment($cabinCompartment)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setDatedOperatingLegRefID($datedOperatingLegRefID);
    }
    /**
     * Get CabinCompartment value
     * @return \StructType\CabinCompartmentType[]
     */
    public function getCabinCompartment()
    {
        return $this->CabinCompartment;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinCompartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinCompartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinCompartmentForArrayConstraintsFromSetCabinCompartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapTypeCabinCompartmentItem) {
            // validation for constraint: itemType
            if (!$seatMapTypeCabinCompartmentItem instanceof \StructType\CabinCompartmentType) {
                $invalidValues[] = is_object($seatMapTypeCabinCompartmentItem) ? get_class($seatMapTypeCabinCompartmentItem) : sprintf('%s(%s)', gettype($seatMapTypeCabinCompartmentItem), var_export($seatMapTypeCabinCompartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinCompartment property can only contain items of type \StructType\CabinCompartmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinCompartment value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinCompartmentType[] $cabinCompartment
     * @return \StructType\SeatMapType
     */
    public function setCabinCompartment(array $cabinCompartment = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinCompartmentArrayErrorMessage = self::validateCabinCompartmentForArrayConstraintsFromSetCabinCompartment($cabinCompartment))) {
            throw new \InvalidArgumentException($cabinCompartmentArrayErrorMessage, __LINE__);
        }
        $this->CabinCompartment = $cabinCompartment;
        return $this;
    }
    /**
     * Add item to CabinCompartment value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinCompartmentType $item
     * @return \StructType\SeatMapType
     */
    public function addToCabinCompartment(\StructType\CabinCompartmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinCompartmentType) {
            throw new \InvalidArgumentException(sprintf('The CabinCompartment property can only contain items of type \StructType\CabinCompartmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinCompartment[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\SeatMapType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]|null
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatMapTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($seatMapTypeDatedOperatingLegRefIDItem) ? get_class($seatMapTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($seatMapTypeDatedOperatingLegRefIDItem), var_export($seatMapTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\SeatMapType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatMapType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
}
