<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAvailResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the Seat Availability Response message.
 * @subpackage Structs
 */
class SeatAvailResponseType extends AbstractStructBase
{
    /**
     * The SeatMap
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of cabins and the seats within in. This information can be used by the Seller to render a graphical Seat Map.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SeatMapType[]
     */
    public $SeatMap;
    /**
     * The ALaCarteOffer
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ALaCarteOfferType
     */
    public $ALaCarteOffer;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsOfferType[]
     */
    public $PaymentFunctions;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyType[]
     */
    public $Policy;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for SeatAvailResponseType
     * @uses SeatAvailResponseType::setSeatMap()
     * @uses SeatAvailResponseType::setALaCarteOffer()
     * @uses SeatAvailResponseType::setDataLists()
     * @uses SeatAvailResponseType::setMetadata()
     * @uses SeatAvailResponseType::setPaymentFunctions()
     * @uses SeatAvailResponseType::setPolicy()
     * @uses SeatAvailResponseType::setProcessing()
     * @uses SeatAvailResponseType::setWarning()
     * @param \StructType\SeatMapType[] $seatMap
     * @param \StructType\ALaCarteOfferType $aLaCarteOffer
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @param \StructType\PolicyType[] $policy
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $seatMap = array(), \StructType\ALaCarteOfferType $aLaCarteOffer = null, \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, array $paymentFunctions = array(), array $policy = array(), \StructType\ResponseParametersResponseType $processing = null, array $warning = array())
    {
        $this
            ->setSeatMap($seatMap)
            ->setALaCarteOffer($aLaCarteOffer)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setPaymentFunctions($paymentFunctions)
            ->setPolicy($policy)
            ->setProcessing($processing)
            ->setWarning($warning);
    }
    /**
     * Get SeatMap value
     * @return \StructType\SeatMapType[]
     */
    public function getSeatMap()
    {
        return $this->SeatMap;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatMap method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatMap method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatMapForArrayConstraintsFromSetSeatMap(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailResponseTypeSeatMapItem) {
            // validation for constraint: itemType
            if (!$seatAvailResponseTypeSeatMapItem instanceof \StructType\SeatMapType) {
                $invalidValues[] = is_object($seatAvailResponseTypeSeatMapItem) ? get_class($seatAvailResponseTypeSeatMapItem) : sprintf('%s(%s)', gettype($seatAvailResponseTypeSeatMapItem), var_export($seatAvailResponseTypeSeatMapItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatMap property can only contain items of type \StructType\SeatMapType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatMap value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapType[] $seatMap
     * @return \StructType\SeatAvailResponseType
     */
    public function setSeatMap(array $seatMap = array())
    {
        // validation for constraint: array
        if ('' !== ($seatMapArrayErrorMessage = self::validateSeatMapForArrayConstraintsFromSetSeatMap($seatMap))) {
            throw new \InvalidArgumentException($seatMapArrayErrorMessage, __LINE__);
        }
        $this->SeatMap = $seatMap;
        return $this;
    }
    /**
     * Add item to SeatMap value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapType $item
     * @return \StructType\SeatAvailResponseType
     */
    public function addToSeatMap(\StructType\SeatMapType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatMapType) {
            throw new \InvalidArgumentException(sprintf('The SeatMap property can only contain items of type \StructType\SeatMapType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatMap[] = $item;
        return $this;
    }
    /**
     * Get ALaCarteOffer value
     * @return \StructType\ALaCarteOfferType|null
     */
    public function getALaCarteOffer()
    {
        return $this->ALaCarteOffer;
    }
    /**
     * Set ALaCarteOffer value
     * @param \StructType\ALaCarteOfferType $aLaCarteOffer
     * @return \StructType\SeatAvailResponseType
     */
    public function setALaCarteOffer(\StructType\ALaCarteOfferType $aLaCarteOffer = null)
    {
        $this->ALaCarteOffer = $aLaCarteOffer;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\SeatAvailResponseType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\SeatAvailResponseType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsOfferType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailResponseTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$seatAvailResponseTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsOfferType) {
                $invalidValues[] = is_object($seatAvailResponseTypePaymentFunctionsItem) ? get_class($seatAvailResponseTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($seatAvailResponseTypePaymentFunctionsItem), var_export($seatAvailResponseTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @return \StructType\SeatAvailResponseType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType $item
     * @return \StructType\SeatAvailResponseType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsOfferType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailResponseTypePolicyItem) {
            // validation for constraint: itemType
            if (!$seatAvailResponseTypePolicyItem instanceof \StructType\PolicyType) {
                $invalidValues[] = is_object($seatAvailResponseTypePolicyItem) ? get_class($seatAvailResponseTypePolicyItem) : sprintf('%s(%s)', gettype($seatAvailResponseTypePolicyItem), var_export($seatAvailResponseTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType[] $policy
     * @return \StructType\SeatAvailResponseType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType $item
     * @return \StructType\SeatAvailResponseType
     */
    public function addToPolicy(\StructType\PolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyType) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\SeatAvailResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$seatAvailResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($seatAvailResponseTypeWarningItem) ? get_class($seatAvailResponseTypeWarningItem) : sprintf('%s(%s)', gettype($seatAvailResponseTypeWarningItem), var_export($seatAvailResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\SeatAvailResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\SeatAvailResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
