<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAvailOfferRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a request using offers
 * @subpackage Structs
 */
class SeatAvailOfferRequestType extends AbstractStructBase
{
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - documentation: This is a specialized seat availability offer used in the context of a Shopping Request. Generic offer definition is: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be
     * the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this
     * structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items
     * here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SeatAvailOfferType[]
     */
    public $Offer;
    /**
     * Constructor method for SeatAvailOfferRequestType
     * @uses SeatAvailOfferRequestType::setOffer()
     * @param \StructType\SeatAvailOfferType[] $offer
     */
    public function __construct(array $offer = array())
    {
        $this
            ->setOffer($offer);
    }
    /**
     * Get Offer value
     * @return \StructType\SeatAvailOfferType[]
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailOfferRequestTypeOfferItem) {
            // validation for constraint: itemType
            if (!$seatAvailOfferRequestTypeOfferItem instanceof \StructType\SeatAvailOfferType) {
                $invalidValues[] = is_object($seatAvailOfferRequestTypeOfferItem) ? get_class($seatAvailOfferRequestTypeOfferItem) : sprintf('%s(%s)', gettype($seatAvailOfferRequestTypeOfferItem), var_export($seatAvailOfferRequestTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\SeatAvailOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatAvailOfferType[] $offer
     * @return \StructType\SeatAvailOfferRequestType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatAvailOfferType $item
     * @return \StructType\SeatAvailOfferRequestType
     */
    public function addToOffer(\StructType\SeatAvailOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatAvailOfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\SeatAvailOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
}
