<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesTaxRegistrationType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Identification and contact information of a party purchasing goods or services as registered with a Purchase Tax.
 * @subpackage Structs
 */
class SalesTaxRegistrationType extends AbstractStructBase
{
    /**
     * The EmailAddressText
     * Meta information extracted from the WSDL
     * - documentation: The email address which should be used for contact purposes. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EmailAddressText;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the city, town or village. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The CountryDialingCode
     * Meta information extracted from the WSDL
     * - documentation: Numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU). Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code,
     * area code, phone number and extension. | Enumeration set for the Country Dialing Code BDT. | Additional BDT to specify the numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU).
     * - base: CountryDialingCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryDialingCode;
    /**
     * The CountrySubDivisionName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the sub-division of a country. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountrySubDivisionName;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Phone number text. Examples: +1 999-999-9999 ext 1234, 617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with the additional attributes to create a structured phone number.
     * | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $PhoneNumber;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Postal code. Examples: 11001, 11001-2345 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The SalesTaxRegistrationID
     * Meta information extracted from the WSDL
     * - documentation: Registered identifier of the business purchasing the goods and services. For example, a GST number in India XX. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesTaxRegistrationID;
    /**
     * The StreetText
     * Meta information extracted from the WSDL
     * - documentation: Street name and number. Examples: Main Street, 100 Main Street | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $StreetText;
    /**
     * Constructor method for SalesTaxRegistrationType
     * @uses SalesTaxRegistrationType::setEmailAddressText()
     * @uses SalesTaxRegistrationType::setCityName()
     * @uses SalesTaxRegistrationType::setCountryCode()
     * @uses SalesTaxRegistrationType::setCountryDialingCode()
     * @uses SalesTaxRegistrationType::setCountrySubDivisionName()
     * @uses SalesTaxRegistrationType::setPhoneNumber()
     * @uses SalesTaxRegistrationType::setPostalCode()
     * @uses SalesTaxRegistrationType::setSalesTaxRegistrationID()
     * @uses SalesTaxRegistrationType::setStreetText()
     * @param string $emailAddressText
     * @param string $cityName
     * @param string $countryCode
     * @param string $countryDialingCode
     * @param string $countrySubDivisionName
     * @param string[] $phoneNumber
     * @param string $postalCode
     * @param string $salesTaxRegistrationID
     * @param string[] $streetText
     */
    public function __construct($emailAddressText = null, $cityName = null, $countryCode = null, $countryDialingCode = null, $countrySubDivisionName = null, array $phoneNumber = array(), $postalCode = null, $salesTaxRegistrationID = null, array $streetText = array())
    {
        $this
            ->setEmailAddressText($emailAddressText)
            ->setCityName($cityName)
            ->setCountryCode($countryCode)
            ->setCountryDialingCode($countryDialingCode)
            ->setCountrySubDivisionName($countrySubDivisionName)
            ->setPhoneNumber($phoneNumber)
            ->setPostalCode($postalCode)
            ->setSalesTaxRegistrationID($salesTaxRegistrationID)
            ->setStreetText($streetText);
    }
    /**
     * Get EmailAddressText value
     * @return string
     */
    public function getEmailAddressText()
    {
        return $this->EmailAddressText;
    }
    /**
     * Set EmailAddressText value
     * @param string $emailAddressText
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setEmailAddressText($emailAddressText = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddressText) && !is_string($emailAddressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddressText, true), gettype($emailAddressText)), __LINE__);
        }
        $this->EmailAddressText = $emailAddressText;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[A-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CountryDialingCode value
     * @return string|null
     */
    public function getCountryDialingCode()
    {
        return $this->CountryDialingCode;
    }
    /**
     * Set CountryDialingCode value
     * @param string $countryDialingCode
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setCountryDialingCode($countryDialingCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryDialingCode) && !is_string($countryDialingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryDialingCode, true), gettype($countryDialingCode)), __LINE__);
        }
        $this->CountryDialingCode = $countryDialingCode;
        return $this;
    }
    /**
     * Get CountrySubDivisionName value
     * @return string|null
     */
    public function getCountrySubDivisionName()
    {
        return $this->CountrySubDivisionName;
    }
    /**
     * Set CountrySubDivisionName value
     * @param string $countrySubDivisionName
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setCountrySubDivisionName($countrySubDivisionName = null)
    {
        // validation for constraint: string
        if (!is_null($countrySubDivisionName) && !is_string($countrySubDivisionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySubDivisionName, true), gettype($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        $this->CountrySubDivisionName = $countrySubDivisionName;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxRegistrationTypePhoneNumberItem) {
            // validation for constraint: itemType
            if (!is_string($salesTaxRegistrationTypePhoneNumberItem)) {
                $invalidValues[] = is_object($salesTaxRegistrationTypePhoneNumberItem) ? get_class($salesTaxRegistrationTypePhoneNumberItem) : sprintf('%s(%s)', gettype($salesTaxRegistrationTypePhoneNumberItem), var_export($salesTaxRegistrationTypePhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param string[] $phoneNumber
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($phoneNumber) && count($phoneNumber) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SalesTaxRegistrationType
     */
    public function addToPhoneNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->PhoneNumber) && count($this->PhoneNumber) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->PhoneNumber)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get SalesTaxRegistrationID value
     * @return string|null
     */
    public function getSalesTaxRegistrationID()
    {
        return $this->SalesTaxRegistrationID;
    }
    /**
     * Set SalesTaxRegistrationID value
     * @param string $salesTaxRegistrationID
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setSalesTaxRegistrationID($salesTaxRegistrationID = null)
    {
        // validation for constraint: string
        if (!is_null($salesTaxRegistrationID) && !is_string($salesTaxRegistrationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesTaxRegistrationID, true), gettype($salesTaxRegistrationID)), __LINE__);
        }
        $this->SalesTaxRegistrationID = $salesTaxRegistrationID;
        return $this;
    }
    /**
     * Get StreetText value
     * @return string[]|null
     */
    public function getStreetText()
    {
        return $this->StreetText;
    }
    /**
     * This method is responsible for validating the values passed to the setStreetText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetTextForArrayConstraintsFromSetStreetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxRegistrationTypeStreetTextItem) {
            // validation for constraint: itemType
            if (!is_string($salesTaxRegistrationTypeStreetTextItem)) {
                $invalidValues[] = is_object($salesTaxRegistrationTypeStreetTextItem) ? get_class($salesTaxRegistrationTypeStreetTextItem) : sprintf('%s(%s)', gettype($salesTaxRegistrationTypeStreetTextItem), var_export($salesTaxRegistrationTypeStreetTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StreetText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StreetText value
     * @throws \InvalidArgumentException
     * @param string[] $streetText
     * @return \StructType\SalesTaxRegistrationType
     */
    public function setStreetText(array $streetText = array())
    {
        // validation for constraint: array
        if ('' !== ($streetTextArrayErrorMessage = self::validateStreetTextForArrayConstraintsFromSetStreetText($streetText))) {
            throw new \InvalidArgumentException($streetTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($streetText) && count($streetText) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($streetText)), __LINE__);
        }
        $this->StreetText = $streetText;
        return $this;
    }
    /**
     * Add item to StreetText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SalesTaxRegistrationType
     */
    public function addToStreetText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StreetText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->StreetText) && count($this->StreetText) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->StreetText)), __LINE__);
        }
        $this->StreetText[] = $item;
        return $this;
    }
}
