<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RulesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A rules type
 * @subpackage Structs
 */
class RulesType extends AbstractStructBase
{
    /**
     * The AirlineDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $AirlineDesigCode;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportPointType
     */
    public $Arrival;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: This is a transport point location.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportPointType
     */
    public $Dep;
    /**
     * The FareRuleText
     * Meta information extracted from the WSDL
     * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareRuleTextType[]
     */
    public $FareRuleText;
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - documentation: Information related to a punishment imposed for breaking a law, rule, or contract.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RulesPenaltyType[]
     */
    public $Penalty;
    /**
     * Constructor method for RulesType
     * @uses RulesType::setAirlineDesigCode()
     * @uses RulesType::setArrival()
     * @uses RulesType::setDep()
     * @uses RulesType::setFareRuleText()
     * @uses RulesType::setPenalty()
     * @param string $airlineDesigCode
     * @param \StructType\TransportPointType $arrival
     * @param \StructType\TransportPointType $dep
     * @param \StructType\FareRuleTextType[] $fareRuleText
     * @param \StructType\RulesPenaltyType[] $penalty
     */
    public function __construct($airlineDesigCode = null, \StructType\TransportPointType $arrival = null, \StructType\TransportPointType $dep = null, array $fareRuleText = array(), array $penalty = array())
    {
        $this
            ->setAirlineDesigCode($airlineDesigCode)
            ->setArrival($arrival)
            ->setDep($dep)
            ->setFareRuleText($fareRuleText)
            ->setPenalty($penalty);
    }
    /**
     * Get AirlineDesigCode value
     * @return string
     */
    public function getAirlineDesigCode()
    {
        return $this->AirlineDesigCode;
    }
    /**
     * Set AirlineDesigCode value
     * @param string $airlineDesigCode
     * @return \StructType\RulesType
     */
    public function setAirlineDesigCode($airlineDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineDesigCode) && !is_string($airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineDesigCode, true), gettype($airlineDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($airlineDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($airlineDesigCode, true)), __LINE__);
        }
        $this->AirlineDesigCode = $airlineDesigCode;
        return $this;
    }
    /**
     * Get Arrival value
     * @return \StructType\TransportPointType|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\TransportPointType $arrival
     * @return \StructType\RulesType
     */
    public function setArrival(\StructType\TransportPointType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\TransportPointType|null
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\TransportPointType $dep
     * @return \StructType\RulesType
     */
    public function setDep(\StructType\TransportPointType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get FareRuleText value
     * @return \StructType\FareRuleTextType[]|null
     */
    public function getFareRuleText()
    {
        return $this->FareRuleText;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRuleText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRuleText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRuleTextForArrayConstraintsFromSetFareRuleText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesTypeFareRuleTextItem) {
            // validation for constraint: itemType
            if (!$rulesTypeFareRuleTextItem instanceof \StructType\FareRuleTextType) {
                $invalidValues[] = is_object($rulesTypeFareRuleTextItem) ? get_class($rulesTypeFareRuleTextItem) : sprintf('%s(%s)', gettype($rulesTypeFareRuleTextItem), var_export($rulesTypeFareRuleTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRuleText property can only contain items of type \StructType\FareRuleTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRuleText value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleTextType[] $fareRuleText
     * @return \StructType\RulesType
     */
    public function setFareRuleText(array $fareRuleText = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRuleTextArrayErrorMessage = self::validateFareRuleTextForArrayConstraintsFromSetFareRuleText($fareRuleText))) {
            throw new \InvalidArgumentException($fareRuleTextArrayErrorMessage, __LINE__);
        }
        $this->FareRuleText = $fareRuleText;
        return $this;
    }
    /**
     * Add item to FareRuleText value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleTextType $item
     * @return \StructType\RulesType
     */
    public function addToFareRuleText(\StructType\FareRuleTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRuleTextType) {
            throw new \InvalidArgumentException(sprintf('The FareRuleText property can only contain items of type \StructType\FareRuleTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareRuleText[] = $item;
        return $this;
    }
    /**
     * Get Penalty value
     * @return \StructType\RulesPenaltyType[]|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * This method is responsible for validating the values passed to the setPenalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyForArrayConstraintsFromSetPenalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesTypePenaltyItem) {
            // validation for constraint: itemType
            if (!$rulesTypePenaltyItem instanceof \StructType\RulesPenaltyType) {
                $invalidValues[] = is_object($rulesTypePenaltyItem) ? get_class($rulesTypePenaltyItem) : sprintf('%s(%s)', gettype($rulesTypePenaltyItem), var_export($rulesTypePenaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Penalty property can only contain items of type \StructType\RulesPenaltyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Penalty value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesPenaltyType[] $penalty
     * @return \StructType\RulesType
     */
    public function setPenalty(array $penalty = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyArrayErrorMessage = self::validatePenaltyForArrayConstraintsFromSetPenalty($penalty))) {
            throw new \InvalidArgumentException($penaltyArrayErrorMessage, __LINE__);
        }
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesPenaltyType $item
     * @return \StructType\RulesType
     */
    public function addToPenalty(\StructType\RulesPenaltyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RulesPenaltyType) {
            throw new \InvalidArgumentException(sprintf('The Penalty property can only contain items of type \StructType\RulesPenaltyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Penalty[] = $item;
        return $this;
    }
}
