<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RulesFareDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
 * @subpackage Structs
 */
class RulesFareDetailType extends AbstractStructBase
{
    /**
     * The FarePriceType
     * Meta information extracted from the WSDL
     * - documentation: An additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
     * - maxOccurs: 2
     * - minOccurs: 1
     * @var \StructType\FarePriceTypeType[]
     */
    public $FarePriceType;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: Corporate ID used for pricing special fares. Example: 675124 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * The FareCalculationInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the calculation of the Fare amount by applying various rules to determine a final fare for an airline ticket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FareCalculationInfoType
     */
    public $FareCalculationInfo;
    /**
     * The FareIndCode
     * Meta information extracted from the WSDL
     * - documentation: Fare indicator code. Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION) Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier | A code is a character string of letters, numbers, special characters
     * (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareIndCode;
    /**
     * The FareRefText
     * Meta information extracted from the WSDL
     * - documentation: Fare reference key, ex: PQ123456 | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareRefText;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The FiledFareInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, a component of this fare has been priced using filed fare data. If FALSE, dynamic pricing has been applied. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a
     * property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FiledFareInd;
    /**
     * The NetReportingCodeText
     * Meta information extracted from the WSDL
     * - documentation: Code indicating if the transaction is subject to a net reporting arrangement. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NetReportingCodeText;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The PricingSystemCodeText
     * Meta information extracted from the WSDL
     * - documentation: IATA assigned code identifying the system used to price the itinerary for the document being issued. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingSystemCodeText;
    /**
     * The RulesFareComponent
     * Meta information extracted from the WSDL
     * - documentation: A portion of an itinerary between two consecutive fare construction points. If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RulesFareComponentType[]
     */
    public $RulesFareComponent;
    /**
     * The StatisticalCodeText
     * Meta information extracted from the WSDL
     * - documentation: Code used for domestic or international sales differentiation. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatisticalCodeText;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: Tour Code. Example: ITGF12 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TourCode;
    /**
     * Constructor method for RulesFareDetailType
     * @uses RulesFareDetailType::setFarePriceType()
     * @uses RulesFareDetailType::setAccountCode()
     * @uses RulesFareDetailType::setFareCalculationInfo()
     * @uses RulesFareDetailType::setFareIndCode()
     * @uses RulesFareDetailType::setFareRefText()
     * @uses RulesFareDetailType::setFareWaiver()
     * @uses RulesFareDetailType::setFiledFareInd()
     * @uses RulesFareDetailType::setNetReportingCodeText()
     * @uses RulesFareDetailType::setPaxRefID()
     * @uses RulesFareDetailType::setPrice()
     * @uses RulesFareDetailType::setPricingSystemCodeText()
     * @uses RulesFareDetailType::setRulesFareComponent()
     * @uses RulesFareDetailType::setStatisticalCodeText()
     * @uses RulesFareDetailType::setTourCode()
     * @param \StructType\FarePriceTypeType[] $farePriceType
     * @param string $accountCode
     * @param \StructType\FareCalculationInfoType $fareCalculationInfo
     * @param string $fareIndCode
     * @param string $fareRefText
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param bool $filedFareInd
     * @param string $netReportingCodeText
     * @param string[] $paxRefID
     * @param \StructType\PriceType $price
     * @param string $pricingSystemCodeText
     * @param \StructType\RulesFareComponentType[] $rulesFareComponent
     * @param string $statisticalCodeText
     * @param string $tourCode
     */
    public function __construct(array $farePriceType = array(), $accountCode = null, \StructType\FareCalculationInfoType $fareCalculationInfo = null, $fareIndCode = null, $fareRefText = null, array $fareWaiver = array(), $filedFareInd = null, $netReportingCodeText = null, array $paxRefID = array(), \StructType\PriceType $price = null, $pricingSystemCodeText = null, array $rulesFareComponent = array(), $statisticalCodeText = null, $tourCode = null)
    {
        $this
            ->setFarePriceType($farePriceType)
            ->setAccountCode($accountCode)
            ->setFareCalculationInfo($fareCalculationInfo)
            ->setFareIndCode($fareIndCode)
            ->setFareRefText($fareRefText)
            ->setFareWaiver($fareWaiver)
            ->setFiledFareInd($filedFareInd)
            ->setNetReportingCodeText($netReportingCodeText)
            ->setPaxRefID($paxRefID)
            ->setPrice($price)
            ->setPricingSystemCodeText($pricingSystemCodeText)
            ->setRulesFareComponent($rulesFareComponent)
            ->setStatisticalCodeText($statisticalCodeText)
            ->setTourCode($tourCode);
    }
    /**
     * Get FarePriceType value
     * @return \StructType\FarePriceTypeType[]
     */
    public function getFarePriceType()
    {
        return $this->FarePriceType;
    }
    /**
     * This method is responsible for validating the values passed to the setFarePriceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFarePriceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFarePriceTypeForArrayConstraintsFromSetFarePriceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesFareDetailTypeFarePriceTypeItem) {
            // validation for constraint: itemType
            if (!$rulesFareDetailTypeFarePriceTypeItem instanceof \StructType\FarePriceTypeType) {
                $invalidValues[] = is_object($rulesFareDetailTypeFarePriceTypeItem) ? get_class($rulesFareDetailTypeFarePriceTypeItem) : sprintf('%s(%s)', gettype($rulesFareDetailTypeFarePriceTypeItem), var_export($rulesFareDetailTypeFarePriceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FarePriceType property can only contain items of type \StructType\FarePriceTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FarePriceType value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePriceTypeType[] $farePriceType
     * @return \StructType\RulesFareDetailType
     */
    public function setFarePriceType(array $farePriceType = array())
    {
        // validation for constraint: array
        if ('' !== ($farePriceTypeArrayErrorMessage = self::validateFarePriceTypeForArrayConstraintsFromSetFarePriceType($farePriceType))) {
            throw new \InvalidArgumentException($farePriceTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($farePriceType) && count($farePriceType) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($farePriceType)), __LINE__);
        }
        $this->FarePriceType = $farePriceType;
        return $this;
    }
    /**
     * Add item to FarePriceType value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePriceTypeType $item
     * @return \StructType\RulesFareDetailType
     */
    public function addToFarePriceType(\StructType\FarePriceTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FarePriceTypeType) {
            throw new \InvalidArgumentException(sprintf('The FarePriceType property can only contain items of type \StructType\FarePriceTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->FarePriceType) && count($this->FarePriceType) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->FarePriceType)), __LINE__);
        }
        $this->FarePriceType[] = $item;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\RulesFareDetailType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get FareCalculationInfo value
     * @return \StructType\FareCalculationInfoType|null
     */
    public function getFareCalculationInfo()
    {
        return $this->FareCalculationInfo;
    }
    /**
     * Set FareCalculationInfo value
     * @param \StructType\FareCalculationInfoType $fareCalculationInfo
     * @return \StructType\RulesFareDetailType
     */
    public function setFareCalculationInfo(\StructType\FareCalculationInfoType $fareCalculationInfo = null)
    {
        $this->FareCalculationInfo = $fareCalculationInfo;
        return $this;
    }
    /**
     * Get FareIndCode value
     * @return string|null
     */
    public function getFareIndCode()
    {
        return $this->FareIndCode;
    }
    /**
     * Set FareIndCode value
     * @param string $fareIndCode
     * @return \StructType\RulesFareDetailType
     */
    public function setFareIndCode($fareIndCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareIndCode) && !is_string($fareIndCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareIndCode, true), gettype($fareIndCode)), __LINE__);
        }
        $this->FareIndCode = $fareIndCode;
        return $this;
    }
    /**
     * Get FareRefText value
     * @return string|null
     */
    public function getFareRefText()
    {
        return $this->FareRefText;
    }
    /**
     * Set FareRefText value
     * @param string $fareRefText
     * @return \StructType\RulesFareDetailType
     */
    public function setFareRefText($fareRefText = null)
    {
        // validation for constraint: string
        if (!is_null($fareRefText) && !is_string($fareRefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRefText, true), gettype($fareRefText)), __LINE__);
        }
        $this->FareRefText = $fareRefText;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesFareDetailTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$rulesFareDetailTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($rulesFareDetailTypeFareWaiverItem) ? get_class($rulesFareDetailTypeFareWaiverItem) : sprintf('%s(%s)', gettype($rulesFareDetailTypeFareWaiverItem), var_export($rulesFareDetailTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\RulesFareDetailType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($fareWaiver) && count($fareWaiver) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($fareWaiver)), __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\RulesFareDetailType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->FareWaiver) && count($this->FareWaiver) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->FareWaiver)), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get FiledFareInd value
     * @return bool|null
     */
    public function getFiledFareInd()
    {
        return $this->FiledFareInd;
    }
    /**
     * Set FiledFareInd value
     * @param bool $filedFareInd
     * @return \StructType\RulesFareDetailType
     */
    public function setFiledFareInd($filedFareInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($filedFareInd) && !is_bool($filedFareInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filedFareInd, true), gettype($filedFareInd)), __LINE__);
        }
        $this->FiledFareInd = $filedFareInd;
        return $this;
    }
    /**
     * Get NetReportingCodeText value
     * @return string|null
     */
    public function getNetReportingCodeText()
    {
        return $this->NetReportingCodeText;
    }
    /**
     * Set NetReportingCodeText value
     * @param string $netReportingCodeText
     * @return \StructType\RulesFareDetailType
     */
    public function setNetReportingCodeText($netReportingCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($netReportingCodeText) && !is_string($netReportingCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netReportingCodeText, true), gettype($netReportingCodeText)), __LINE__);
        }
        $this->NetReportingCodeText = $netReportingCodeText;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesFareDetailTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($rulesFareDetailTypePaxRefIDItem)) {
                $invalidValues[] = is_object($rulesFareDetailTypePaxRefIDItem) ? get_class($rulesFareDetailTypePaxRefIDItem) : sprintf('%s(%s)', gettype($rulesFareDetailTypePaxRefIDItem), var_export($rulesFareDetailTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\RulesFareDetailType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RulesFareDetailType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\RulesFareDetailType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PricingSystemCodeText value
     * @return string|null
     */
    public function getPricingSystemCodeText()
    {
        return $this->PricingSystemCodeText;
    }
    /**
     * Set PricingSystemCodeText value
     * @param string $pricingSystemCodeText
     * @return \StructType\RulesFareDetailType
     */
    public function setPricingSystemCodeText($pricingSystemCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($pricingSystemCodeText) && !is_string($pricingSystemCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingSystemCodeText, true), gettype($pricingSystemCodeText)), __LINE__);
        }
        $this->PricingSystemCodeText = $pricingSystemCodeText;
        return $this;
    }
    /**
     * Get RulesFareComponent value
     * @return \StructType\RulesFareComponentType[]|null
     */
    public function getRulesFareComponent()
    {
        return $this->RulesFareComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setRulesFareComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRulesFareComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRulesFareComponentForArrayConstraintsFromSetRulesFareComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesFareDetailTypeRulesFareComponentItem) {
            // validation for constraint: itemType
            if (!$rulesFareDetailTypeRulesFareComponentItem instanceof \StructType\RulesFareComponentType) {
                $invalidValues[] = is_object($rulesFareDetailTypeRulesFareComponentItem) ? get_class($rulesFareDetailTypeRulesFareComponentItem) : sprintf('%s(%s)', gettype($rulesFareDetailTypeRulesFareComponentItem), var_export($rulesFareDetailTypeRulesFareComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RulesFareComponent property can only contain items of type \StructType\RulesFareComponentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RulesFareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesFareComponentType[] $rulesFareComponent
     * @return \StructType\RulesFareDetailType
     */
    public function setRulesFareComponent(array $rulesFareComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($rulesFareComponentArrayErrorMessage = self::validateRulesFareComponentForArrayConstraintsFromSetRulesFareComponent($rulesFareComponent))) {
            throw new \InvalidArgumentException($rulesFareComponentArrayErrorMessage, __LINE__);
        }
        $this->RulesFareComponent = $rulesFareComponent;
        return $this;
    }
    /**
     * Add item to RulesFareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesFareComponentType $item
     * @return \StructType\RulesFareDetailType
     */
    public function addToRulesFareComponent(\StructType\RulesFareComponentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RulesFareComponentType) {
            throw new \InvalidArgumentException(sprintf('The RulesFareComponent property can only contain items of type \StructType\RulesFareComponentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RulesFareComponent[] = $item;
        return $this;
    }
    /**
     * Get StatisticalCodeText value
     * @return string|null
     */
    public function getStatisticalCodeText()
    {
        return $this->StatisticalCodeText;
    }
    /**
     * Set StatisticalCodeText value
     * @param string $statisticalCodeText
     * @return \StructType\RulesFareDetailType
     */
    public function setStatisticalCodeText($statisticalCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalCodeText) && !is_string($statisticalCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticalCodeText, true), gettype($statisticalCodeText)), __LINE__);
        }
        $this->StatisticalCodeText = $statisticalCodeText;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\RulesFareDetailType
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
}
