<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RulesCoreRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Rules Core Request
 * @subpackage Structs
 */
class RulesCoreRequestType extends AbstractStructBase
{
    /**
     * The FareRef
     * Meta information extracted from the WSDL
     * - documentation: To be used when requesting filed fare information as part of this request.
     * - choice: FareRef | OrderStructureKey
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FareRefType
     */
    public $FareRef;
    /**
     * The OrderStructureKey
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - choice: FareRef | OrderStructureKey
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderStructureKeyType
     */
    public $OrderStructureKey;
    /**
     * Constructor method for RulesCoreRequestType
     * @uses RulesCoreRequestType::setFareRef()
     * @uses RulesCoreRequestType::setOrderStructureKey()
     * @param \StructType\FareRefType $fareRef
     * @param \StructType\OrderStructureKeyType $orderStructureKey
     */
    public function __construct(\StructType\FareRefType $fareRef = null, \StructType\OrderStructureKeyType $orderStructureKey = null)
    {
        $this
            ->setFareRef($fareRef)
            ->setOrderStructureKey($orderStructureKey);
    }
    /**
     * Get FareRef value
     * @return \StructType\FareRefType
     */
    public function getFareRef()
    {
        return isset($this->FareRef) ? $this->FareRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFareRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFareRefForChoiceConstraintsFromSetFareRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderStructureKey',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FareRef can\'t be set as the property %s is already set. Only one property must be set among these properties: FareRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FareRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FareRefType $fareRef
     * @return \StructType\RulesCoreRequestType
     */
    public function setFareRef(\StructType\FareRefType $fareRef = null)
    {
        // validation for constraint: choice(FareRef, OrderStructureKey)
        if ('' !== ($fareRefChoiceErrorMessage = self::validateFareRefForChoiceConstraintsFromSetFareRef($fareRef))) {
            throw new \InvalidArgumentException($fareRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($fareRef) || (is_array($fareRef) && empty($fareRef))) {
            unset($this->FareRef);
        } else {
            $this->FareRef = $fareRef;
        }
        return $this;
    }
    /**
     * Get OrderStructureKey value
     * @return \StructType\OrderStructureKeyType
     */
    public function getOrderStructureKey()
    {
        return isset($this->OrderStructureKey) ? $this->OrderStructureKey : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrderStructureKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderStructureKey method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrderStructureKeyForChoiceConstraintsFromSetOrderStructureKey($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FareRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderStructureKey can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderStructureKey, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OrderStructureKey value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStructureKeyType $orderStructureKey
     * @return \StructType\RulesCoreRequestType
     */
    public function setOrderStructureKey(\StructType\OrderStructureKeyType $orderStructureKey = null)
    {
        // validation for constraint: choice(FareRef, OrderStructureKey)
        if ('' !== ($orderStructureKeyChoiceErrorMessage = self::validateOrderStructureKeyForChoiceConstraintsFromSetOrderStructureKey($orderStructureKey))) {
            throw new \InvalidArgumentException($orderStructureKeyChoiceErrorMessage, __LINE__);
        }
        if (is_null($orderStructureKey) || (is_array($orderStructureKey) && empty($orderStructureKey))) {
            unset($this->OrderStructureKey);
        } else {
            $this->OrderStructureKey = $orderStructureKey;
        }
        return $this;
    }
}
