<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseParametersOrderChangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of Information related to how response results should be returned.
 * @subpackage Structs
 */
class ResponseParametersOrderChangeType extends AbstractStructBase
{
    /**
     * The BDC
     * Meta information extracted from the WSDL
     * - documentation: A carrier whose baggage allowances and charges apply.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BDC_Type
     */
    public $BDC;
    /**
     * The CurParameter
     * Meta information extracted from the WSDL
     * - documentation: Currency related parameters intended to influence which currency the shopping results are displayed in.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurParameterType[]
     */
    public $CurParameter;
    /**
     * The Device
     * Meta information extracted from the WSDL
     * - documentation: Device upon which the secure transaction will occur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceType
     */
    public $Device;
    /**
     * The DeviceLocation
     * Meta information extracted from the WSDL
     * - documentation: Location of device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceLocationType
     */
    public $DeviceLocation;
    /**
     * The InventoryGuaranteeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, inventory guarantee is requested for applicable optional services. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InventoryGuaranteeInd;
    /**
     * The MeasurementSystemCode
     * Meta information extracted from the WSDL
     * - documentation: Measurement system code. Examples: Imperial, Metric | BDT to represent measurement system codes (e.g. Imperial, Metric).
     * - base: MeasurementSystemCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeasurementSystemCode;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The PricingParameter
     * Meta information extracted from the WSDL
     * - documentation: Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PricingParameterType
     */
    public $PricingParameter;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Should be used for the Seller to communicate the reason for cancellation to the Seller (and for the Airline to respond with advice on the cancellation request. Uses ATSB Codeset: CHR Indicating the reason for change. | A code is a
     * character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCode;
    /**
     * The RefundFOP
     * Meta information extracted from the WSDL
     * - documentation: Refund FOP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RefundFOP_Type
     */
    public $RefundFOP;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * Constructor method for ResponseParametersOrderChangeType
     * @uses ResponseParametersOrderChangeType::setBDC()
     * @uses ResponseParametersOrderChangeType::setCurParameter()
     * @uses ResponseParametersOrderChangeType::setDevice()
     * @uses ResponseParametersOrderChangeType::setDeviceLocation()
     * @uses ResponseParametersOrderChangeType::setInventoryGuaranteeInd()
     * @uses ResponseParametersOrderChangeType::setMeasurementSystemCode()
     * @uses ResponseParametersOrderChangeType::setPaxGroup()
     * @uses ResponseParametersOrderChangeType::setPricingParameter()
     * @uses ResponseParametersOrderChangeType::setReasonCode()
     * @uses ResponseParametersOrderChangeType::setRefundFOP()
     * @uses ResponseParametersOrderChangeType::setRemark()
     * @param \StructType\BDC_Type $bDC
     * @param \StructType\CurParameterType[] $curParameter
     * @param \StructType\DeviceType $device
     * @param \StructType\DeviceLocationType $deviceLocation
     * @param bool $inventoryGuaranteeInd
     * @param string $measurementSystemCode
     * @param \StructType\PaxGroupType $paxGroup
     * @param \StructType\PricingParameterType $pricingParameter
     * @param string $reasonCode
     * @param \StructType\RefundFOP_Type $refundFOP
     * @param \StructType\RemarkType[] $remark
     */
    public function __construct(\StructType\BDC_Type $bDC = null, array $curParameter = array(), \StructType\DeviceType $device = null, \StructType\DeviceLocationType $deviceLocation = null, $inventoryGuaranteeInd = null, $measurementSystemCode = null, \StructType\PaxGroupType $paxGroup = null, \StructType\PricingParameterType $pricingParameter = null, $reasonCode = null, \StructType\RefundFOP_Type $refundFOP = null, array $remark = array())
    {
        $this
            ->setBDC($bDC)
            ->setCurParameter($curParameter)
            ->setDevice($device)
            ->setDeviceLocation($deviceLocation)
            ->setInventoryGuaranteeInd($inventoryGuaranteeInd)
            ->setMeasurementSystemCode($measurementSystemCode)
            ->setPaxGroup($paxGroup)
            ->setPricingParameter($pricingParameter)
            ->setReasonCode($reasonCode)
            ->setRefundFOP($refundFOP)
            ->setRemark($remark);
    }
    /**
     * Get BDC value
     * @return \StructType\BDC_Type|null
     */
    public function getBDC()
    {
        return $this->BDC;
    }
    /**
     * Set BDC value
     * @param \StructType\BDC_Type $bDC
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setBDC(\StructType\BDC_Type $bDC = null)
    {
        $this->BDC = $bDC;
        return $this;
    }
    /**
     * Get CurParameter value
     * @return \StructType\CurParameterType[]|null
     */
    public function getCurParameter()
    {
        return $this->CurParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setCurParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurParameterForArrayConstraintsFromSetCurParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersOrderChangeTypeCurParameterItem) {
            // validation for constraint: itemType
            if (!$responseParametersOrderChangeTypeCurParameterItem instanceof \StructType\CurParameterType) {
                $invalidValues[] = is_object($responseParametersOrderChangeTypeCurParameterItem) ? get_class($responseParametersOrderChangeTypeCurParameterItem) : sprintf('%s(%s)', gettype($responseParametersOrderChangeTypeCurParameterItem), var_export($responseParametersOrderChangeTypeCurParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurParameter property can only contain items of type \StructType\CurParameterType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CurParameterType[] $curParameter
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setCurParameter(array $curParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($curParameterArrayErrorMessage = self::validateCurParameterForArrayConstraintsFromSetCurParameter($curParameter))) {
            throw new \InvalidArgumentException($curParameterArrayErrorMessage, __LINE__);
        }
        $this->CurParameter = $curParameter;
        return $this;
    }
    /**
     * Add item to CurParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CurParameterType $item
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function addToCurParameter(\StructType\CurParameterType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurParameterType) {
            throw new \InvalidArgumentException(sprintf('The CurParameter property can only contain items of type \StructType\CurParameterType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurParameter[] = $item;
        return $this;
    }
    /**
     * Get Device value
     * @return \StructType\DeviceType|null
     */
    public function getDevice()
    {
        return $this->Device;
    }
    /**
     * Set Device value
     * @param \StructType\DeviceType $device
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setDevice(\StructType\DeviceType $device = null)
    {
        $this->Device = $device;
        return $this;
    }
    /**
     * Get DeviceLocation value
     * @return \StructType\DeviceLocationType|null
     */
    public function getDeviceLocation()
    {
        return $this->DeviceLocation;
    }
    /**
     * Set DeviceLocation value
     * @param \StructType\DeviceLocationType $deviceLocation
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setDeviceLocation(\StructType\DeviceLocationType $deviceLocation = null)
    {
        $this->DeviceLocation = $deviceLocation;
        return $this;
    }
    /**
     * Get InventoryGuaranteeInd value
     * @return bool|null
     */
    public function getInventoryGuaranteeInd()
    {
        return $this->InventoryGuaranteeInd;
    }
    /**
     * Set InventoryGuaranteeInd value
     * @param bool $inventoryGuaranteeInd
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setInventoryGuaranteeInd($inventoryGuaranteeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($inventoryGuaranteeInd) && !is_bool($inventoryGuaranteeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inventoryGuaranteeInd, true), gettype($inventoryGuaranteeInd)), __LINE__);
        }
        $this->InventoryGuaranteeInd = $inventoryGuaranteeInd;
        return $this;
    }
    /**
     * Get MeasurementSystemCode value
     * @return string|null
     */
    public function getMeasurementSystemCode()
    {
        return $this->MeasurementSystemCode;
    }
    /**
     * Set MeasurementSystemCode value
     * @param string $measurementSystemCode
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setMeasurementSystemCode($measurementSystemCode = null)
    {
        // validation for constraint: string
        if (!is_null($measurementSystemCode) && !is_string($measurementSystemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementSystemCode, true), gettype($measurementSystemCode)), __LINE__);
        }
        $this->MeasurementSystemCode = $measurementSystemCode;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get PricingParameter value
     * @return \StructType\PricingParameterType|null
     */
    public function getPricingParameter()
    {
        return $this->PricingParameter;
    }
    /**
     * Set PricingParameter value
     * @param \StructType\PricingParameterType $pricingParameter
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setPricingParameter(\StructType\PricingParameterType $pricingParameter = null)
    {
        $this->PricingParameter = $pricingParameter;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get RefundFOP value
     * @return \StructType\RefundFOP_Type|null
     */
    public function getRefundFOP()
    {
        return $this->RefundFOP;
    }
    /**
     * Set RefundFOP value
     * @param \StructType\RefundFOP_Type $refundFOP
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setRefundFOP(\StructType\RefundFOP_Type $refundFOP = null)
    {
        $this->RefundFOP = $refundFOP;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersOrderChangeTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$responseParametersOrderChangeTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($responseParametersOrderChangeTypeRemarkItem) ? get_class($responseParametersOrderChangeTypeRemarkItem) : sprintf('%s(%s)', gettype($responseParametersOrderChangeTypeRemarkItem), var_export($responseParametersOrderChangeTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\ResponseParametersOrderChangeType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
