<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepricedOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Function to reprice entire Order (if only OrderID is supplied within Request) or Specific OrderItems (if defined in nested OrderItem elements)
 * @subpackage Structs
 */
class RepricedOrderType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Optionally specify which OrderItem needs to be repriced. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * Constructor method for RepricedOrderType
     * @uses RepricedOrderType::setOrderID()
     * @uses RepricedOrderType::setOwnerCode()
     * @uses RepricedOrderType::setOrderItemRefID()
     * @param string $orderID
     * @param string $ownerCode
     * @param string[] $orderItemRefID
     */
    public function __construct($orderID = null, $ownerCode = null, array $orderItemRefID = array())
    {
        $this
            ->setOrderID($orderID)
            ->setOwnerCode($ownerCode)
            ->setOrderItemRefID($orderItemRefID);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\RepricedOrderType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\RepricedOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string[]|null
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOrderTypeOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($repricedOrderTypeOrderItemRefIDItem)) {
                $invalidValues[] = is_object($repricedOrderTypeOrderItemRefIDItem) ? get_class($repricedOrderTypeOrderItemRefIDItem) : sprintf('%s(%s)', gettype($repricedOrderTypeOrderItemRefIDItem), var_export($repricedOrderTypeOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\RepricedOrderType
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RepricedOrderType
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
}
