<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepricedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
 * @subpackage Structs
 */
class RepricedOfferType extends AbstractStructBase
{
    /**
     * The OfferRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer ID requested in the OrderReshopRQ. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The RepricedOfferItem
     * Meta information extracted from the WSDL
     * - documentation: Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as
     * OfferItems) will then replace
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\RepricedOfferItemType[]
     */
    public $RepricedOfferItem;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The ForfeitedInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Order Forfeited Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferForfeitedInfoListType
     */
    public $ForfeitedInfoList;
    /**
     * The OfferExpirationTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time an offer will persist in an airline's offer management system for use in subsequent transactions. Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again.
     * Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer. Should the offer time limit expire, any other time limit also expires unless an Order has been created or
     * changed. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferExpirationTimeLimitDateTime;
    /**
     * The PenaltyInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Offer Penalty Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferPenaltyInfoListType
     */
    public $PenaltyInfoList;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The RequestedDateInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if
     * airline offer is for another date than requested one. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RequestedDateInd;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * Constructor method for RepricedOfferType
     * @uses RepricedOfferType::setOfferRefID()
     * @uses RepricedOfferType::setOwnerCode()
     * @uses RepricedOfferType::setRepricedOfferItem()
     * @uses RepricedOfferType::setCommission()
     * @uses RepricedOfferType::setForfeitedInfoList()
     * @uses RepricedOfferType::setOfferExpirationTimeLimitDateTime()
     * @uses RepricedOfferType::setPenaltyInfoList()
     * @uses RepricedOfferType::setPenaltyRefID()
     * @uses RepricedOfferType::setRequestedDateInd()
     * @uses RepricedOfferType::setTotalPrice()
     * @param string $offerRefID
     * @param string $ownerCode
     * @param \StructType\RepricedOfferItemType[] $repricedOfferItem
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\OfferForfeitedInfoListType $forfeitedInfoList
     * @param string $offerExpirationTimeLimitDateTime
     * @param \StructType\OfferPenaltyInfoListType $penaltyInfoList
     * @param string[] $penaltyRefID
     * @param bool $requestedDateInd
     * @param \StructType\PriceType $totalPrice
     */
    public function __construct($offerRefID = null, $ownerCode = null, array $repricedOfferItem = array(), array $commission = array(), \StructType\OfferForfeitedInfoListType $forfeitedInfoList = null, $offerExpirationTimeLimitDateTime = null, \StructType\OfferPenaltyInfoListType $penaltyInfoList = null, array $penaltyRefID = array(), $requestedDateInd = null, \StructType\PriceType $totalPrice = null)
    {
        $this
            ->setOfferRefID($offerRefID)
            ->setOwnerCode($ownerCode)
            ->setRepricedOfferItem($repricedOfferItem)
            ->setCommission($commission)
            ->setForfeitedInfoList($forfeitedInfoList)
            ->setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime)
            ->setPenaltyInfoList($penaltyInfoList)
            ->setPenaltyRefID($penaltyRefID)
            ->setRequestedDateInd($requestedDateInd)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get OfferRefID value
     * @return string
     */
    public function getOfferRefID()
    {
        return $this->OfferRefID;
    }
    /**
     * Set OfferRefID value
     * @param string $offerRefID
     * @return \StructType\RepricedOfferType
     */
    public function setOfferRefID($offerRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerRefID) && !is_string($offerRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerRefID, true), gettype($offerRefID)), __LINE__);
        }
        $this->OfferRefID = $offerRefID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\RepricedOfferType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get RepricedOfferItem value
     * @return \StructType\RepricedOfferItemType[]
     */
    public function getRepricedOfferItem()
    {
        return $this->RepricedOfferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setRepricedOfferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRepricedOfferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRepricedOfferItemForArrayConstraintsFromSetRepricedOfferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferTypeRepricedOfferItemItem) {
            // validation for constraint: itemType
            if (!$repricedOfferTypeRepricedOfferItemItem instanceof \StructType\RepricedOfferItemType) {
                $invalidValues[] = is_object($repricedOfferTypeRepricedOfferItemItem) ? get_class($repricedOfferTypeRepricedOfferItemItem) : sprintf('%s(%s)', gettype($repricedOfferTypeRepricedOfferItemItem), var_export($repricedOfferTypeRepricedOfferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RepricedOfferItem property can only contain items of type \StructType\RepricedOfferItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RepricedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RepricedOfferItemType[] $repricedOfferItem
     * @return \StructType\RepricedOfferType
     */
    public function setRepricedOfferItem(array $repricedOfferItem = array())
    {
        // validation for constraint: array
        if ('' !== ($repricedOfferItemArrayErrorMessage = self::validateRepricedOfferItemForArrayConstraintsFromSetRepricedOfferItem($repricedOfferItem))) {
            throw new \InvalidArgumentException($repricedOfferItemArrayErrorMessage, __LINE__);
        }
        $this->RepricedOfferItem = $repricedOfferItem;
        return $this;
    }
    /**
     * Add item to RepricedOfferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RepricedOfferItemType $item
     * @return \StructType\RepricedOfferType
     */
    public function addToRepricedOfferItem(\StructType\RepricedOfferItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RepricedOfferItemType) {
            throw new \InvalidArgumentException(sprintf('The RepricedOfferItem property can only contain items of type \StructType\RepricedOfferItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RepricedOfferItem[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$repricedOfferTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($repricedOfferTypeCommissionItem) ? get_class($repricedOfferTypeCommissionItem) : sprintf('%s(%s)', gettype($repricedOfferTypeCommissionItem), var_export($repricedOfferTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\RepricedOfferType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\RepricedOfferType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get ForfeitedInfoList value
     * @return \StructType\OfferForfeitedInfoListType|null
     */
    public function getForfeitedInfoList()
    {
        return $this->ForfeitedInfoList;
    }
    /**
     * Set ForfeitedInfoList value
     * @param \StructType\OfferForfeitedInfoListType $forfeitedInfoList
     * @return \StructType\RepricedOfferType
     */
    public function setForfeitedInfoList(\StructType\OfferForfeitedInfoListType $forfeitedInfoList = null)
    {
        $this->ForfeitedInfoList = $forfeitedInfoList;
        return $this;
    }
    /**
     * Get OfferExpirationTimeLimitDateTime value
     * @return string|null
     */
    public function getOfferExpirationTimeLimitDateTime()
    {
        return $this->OfferExpirationTimeLimitDateTime;
    }
    /**
     * Set OfferExpirationTimeLimitDateTime value
     * @param string $offerExpirationTimeLimitDateTime
     * @return \StructType\RepricedOfferType
     */
    public function setOfferExpirationTimeLimitDateTime($offerExpirationTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($offerExpirationTimeLimitDateTime) && !is_string($offerExpirationTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerExpirationTimeLimitDateTime, true), gettype($offerExpirationTimeLimitDateTime)), __LINE__);
        }
        $this->OfferExpirationTimeLimitDateTime = $offerExpirationTimeLimitDateTime;
        return $this;
    }
    /**
     * Get PenaltyInfoList value
     * @return \StructType\OfferPenaltyInfoListType|null
     */
    public function getPenaltyInfoList()
    {
        return $this->PenaltyInfoList;
    }
    /**
     * Set PenaltyInfoList value
     * @param \StructType\OfferPenaltyInfoListType $penaltyInfoList
     * @return \StructType\RepricedOfferType
     */
    public function setPenaltyInfoList(\StructType\OfferPenaltyInfoListType $penaltyInfoList = null)
    {
        $this->PenaltyInfoList = $penaltyInfoList;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($repricedOfferTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($repricedOfferTypePenaltyRefIDItem) ? get_class($repricedOfferTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($repricedOfferTypePenaltyRefIDItem), var_export($repricedOfferTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\RepricedOfferType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RepricedOfferType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get RequestedDateInd value
     * @return bool|null
     */
    public function getRequestedDateInd()
    {
        return $this->RequestedDateInd;
    }
    /**
     * Set RequestedDateInd value
     * @param bool $requestedDateInd
     * @return \StructType\RepricedOfferType
     */
    public function setRequestedDateInd($requestedDateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestedDateInd) && !is_bool($requestedDateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requestedDateInd, true), gettype($requestedDateInd)), __LINE__);
        }
        $this->RequestedDateInd = $requestedDateInd;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\RepricedOfferType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
}
