<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepricedOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as
 * OfferItems) will then replace
 * @subpackage Structs
 */
class RepricedOfferItemType extends AbstractStructBase
{
    /**
     * The OriginalOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Original Order Item price which was repriced.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OriginalOrderItemType
     */
    public $OriginalOrderItem;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer Item ID requested in the OrderReshopRQ. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemRefID;
    /**
     * The PaymentTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: Payment Time Limit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentTimeLimitType
     */
    public $PaymentTimeLimit;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PenaltyRefID;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an offer item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either a new shopping process should
     * begin, or the offer should be repriced resulting in a new Offer. Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item. At Order creation (or change)
     * the airline can increase the remaining length of time beyond the original time limit should they wish to. Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline. | A date time
     * identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * Constructor method for RepricedOfferItemType
     * @uses RepricedOfferItemType::setOriginalOrderItem()
     * @uses RepricedOfferItemType::setTotalPrice()
     * @uses RepricedOfferItemType::setCancelRestrictions()
     * @uses RepricedOfferItemType::setChangeRestrictions()
     * @uses RepricedOfferItemType::setCommission()
     * @uses RepricedOfferItemType::setFareDetail()
     * @uses RepricedOfferItemType::setOfferItemRefID()
     * @uses RepricedOfferItemType::setPaymentTimeLimit()
     * @uses RepricedOfferItemType::setPenaltyRefID()
     * @uses RepricedOfferItemType::setPriceGuaranteeTimeLimitDateTime()
     * @param \StructType\OriginalOrderItemType $originalOrderItem
     * @param \StructType\PriceType $totalPrice
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\FareDetailType[] $fareDetail
     * @param string $offerItemRefID
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @param string $penaltyRefID
     * @param string $priceGuaranteeTimeLimitDateTime
     */
    public function __construct(\StructType\OriginalOrderItemType $originalOrderItem = null, \StructType\PriceType $totalPrice = null, array $cancelRestrictions = array(), array $changeRestrictions = array(), array $commission = array(), array $fareDetail = array(), $offerItemRefID = null, \StructType\PaymentTimeLimitType $paymentTimeLimit = null, $penaltyRefID = null, $priceGuaranteeTimeLimitDateTime = null)
    {
        $this
            ->setOriginalOrderItem($originalOrderItem)
            ->setTotalPrice($totalPrice)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCommission($commission)
            ->setFareDetail($fareDetail)
            ->setOfferItemRefID($offerItemRefID)
            ->setPaymentTimeLimit($paymentTimeLimit)
            ->setPenaltyRefID($penaltyRefID)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime);
    }
    /**
     * Get OriginalOrderItem value
     * @return \StructType\OriginalOrderItemType
     */
    public function getOriginalOrderItem()
    {
        return $this->OriginalOrderItem;
    }
    /**
     * Set OriginalOrderItem value
     * @param \StructType\OriginalOrderItemType $originalOrderItem
     * @return \StructType\RepricedOfferItemType
     */
    public function setOriginalOrderItem(\StructType\OriginalOrderItemType $originalOrderItem = null)
    {
        $this->OriginalOrderItem = $originalOrderItem;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\RepricedOfferItemType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$repricedOfferItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($repricedOfferItemTypeCancelRestrictionsItem) ? get_class($repricedOfferItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($repricedOfferItemTypeCancelRestrictionsItem), var_export($repricedOfferItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\RepricedOfferItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\RepricedOfferItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$repricedOfferItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($repricedOfferItemTypeChangeRestrictionsItem) ? get_class($repricedOfferItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($repricedOfferItemTypeChangeRestrictionsItem), var_export($repricedOfferItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\RepricedOfferItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\RepricedOfferItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferItemTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$repricedOfferItemTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($repricedOfferItemTypeCommissionItem) ? get_class($repricedOfferItemTypeCommissionItem) : sprintf('%s(%s)', gettype($repricedOfferItemTypeCommissionItem), var_export($repricedOfferItemTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\RepricedOfferItemType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\RepricedOfferItemType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $repricedOfferItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$repricedOfferItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($repricedOfferItemTypeFareDetailItem) ? get_class($repricedOfferItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($repricedOfferItemTypeFareDetailItem), var_export($repricedOfferItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\RepricedOfferItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\RepricedOfferItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string|null
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * Set OfferItemRefID value
     * @param string $offerItemRefID
     * @return \StructType\RepricedOfferItemType
     */
    public function setOfferItemRefID($offerItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemRefID) && !is_string($offerItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemRefID, true), gettype($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Get PaymentTimeLimit value
     * @return \StructType\PaymentTimeLimitType|null
     */
    public function getPaymentTimeLimit()
    {
        return $this->PaymentTimeLimit;
    }
    /**
     * Set PaymentTimeLimit value
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @return \StructType\RepricedOfferItemType
     */
    public function setPaymentTimeLimit(\StructType\PaymentTimeLimitType $paymentTimeLimit = null)
    {
        $this->PaymentTimeLimit = $paymentTimeLimit;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * Set PenaltyRefID value
     * @param string $penaltyRefID
     * @return \StructType\RepricedOfferItemType
     */
    public function setPenaltyRefID($penaltyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyRefID) && !is_string($penaltyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyRefID, true), gettype($penaltyRefID)), __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\RepricedOfferItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
}
