<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Redemption StructType
 * @subpackage Structs
 */
class Redemption extends AbstractStructBase
{
    /**
     * The Redeem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Redeem[]
     */
    public $Redeem;
    /**
     * The Required
     * @var string
     */
    public $Required;
    /**
     * Constructor method for Redemption
     * @uses Redemption::setRedeem()
     * @uses Redemption::setRequired()
     * @param \StructType\Redeem[] $redeem
     * @param string $required
     */
    public function __construct(array $redeem = array(), $required = null)
    {
        $this
            ->setRedeem($redeem)
            ->setRequired($required);
    }
    /**
     * Get Redeem value
     * @return \StructType\Redeem[]|null
     */
    public function getRedeem()
    {
        return $this->Redeem;
    }
    /**
     * This method is responsible for validating the values passed to the setRedeem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedeem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedeemForArrayConstraintsFromSetRedeem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $redemptionRedeemItem) {
            // validation for constraint: itemType
            if (!$redemptionRedeemItem instanceof \StructType\Redeem) {
                $invalidValues[] = is_object($redemptionRedeemItem) ? get_class($redemptionRedeemItem) : sprintf('%s(%s)', gettype($redemptionRedeemItem), var_export($redemptionRedeemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Redeem property can only contain items of type \StructType\Redeem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Redeem value
     * @throws \InvalidArgumentException
     * @param \StructType\Redeem[] $redeem
     * @return \StructType\Redemption
     */
    public function setRedeem(array $redeem = array())
    {
        // validation for constraint: array
        if ('' !== ($redeemArrayErrorMessage = self::validateRedeemForArrayConstraintsFromSetRedeem($redeem))) {
            throw new \InvalidArgumentException($redeemArrayErrorMessage, __LINE__);
        }
        $this->Redeem = $redeem;
        return $this;
    }
    /**
     * Add item to Redeem value
     * @throws \InvalidArgumentException
     * @param \StructType\Redeem $item
     * @return \StructType\Redemption
     */
    public function addToRedeem(\StructType\Redeem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Redeem) {
            throw new \InvalidArgumentException(sprintf('The Redeem property can only contain items of type \StructType\Redeem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Redeem[] = $item;
        return $this;
    }
    /**
     * Get Required value
     * @return string|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param string $required
     * @return \StructType\Redemption
     */
    public function setRequired($required = null)
    {
        // validation for constraint: string
        if (!is_null($required) && !is_string($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
}
