<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptPaymentCardType StructType
 * Meta information extracted from the WSDL
 * - documentation: A specialization of Payment Card as part of the summary of a processed payment, defined as a device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
 * @subpackage Structs
 */
class ReceiptPaymentCardType extends AbstractStructBase
{
    /**
     * The CardBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case FOID is a
     * Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $CardBrandCode;
    /**
     * The CardholderAddress
     * Meta information extracted from the WSDL
     * - documentation: Natural or physical address used for postal service. May be a building address, airport address, etc.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PostalAddressType
     */
    public $CardholderAddress;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - documentation: Name of credit card holder. Example: JOHN SMITH | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardIssuerName
     * Meta information extracted from the WSDL
     * - documentation: Credit card issuing company name. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardIssuerName;
    /**
     * The CardIssuingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Payment Card issuing country code. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha
     * Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CardIssuingCountryCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: The card number indicated on the payment card. | Data type for Payment Card Number.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9X]{1,19}
     * @var string
     */
    public $CardNumber;
    /**
     * The CardProductTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductTypeCode;
    /**
     * The CardSecurityCode
     * Meta information extracted from the WSDL
     * - documentation: 3-digit number printed on the signature panel on the back of the card and following the last four digits of the Primary Account Number (PAN). For American Express, 4 digits located on the front of the card, above the card number on
     * the right hand side. Visa - CVV2, MasterCard - CVC2, American Express - CID, Discover - CMID, Union Pay - CVN2, JCB - CAV2. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardSecurityCode;
    /**
     * The CardSeqNumber
     * Meta information extracted from the WSDL
     * - documentation: Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CardSeqNumber;
    /**
     * The CardTypeText
     * Meta information extracted from the WSDL
     * - documentation: Additional description for the magnetic stripe card type (debit card, credit card, prepaid card, etc.) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeText;
    /**
     * The CryptographyKey
     * Meta information extracted from the WSDL
     * - documentation: Cryptography Key.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CryptographyKeyType
     */
    public $CryptographyKey;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Payment Card Effective Date. Example: 0116 | BDT used to define card issue/expiry dates in a 4N format.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $EffectiveDate;
    /**
     * The EncryptedData
     * Meta information extracted from the WSDL
     * - documentation: Payment Card details passed onto airline in an encrypted format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptedDataType
     */
    public $EncryptedData;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: The last month of validity Example: 0119 | BDT used to define card issue/expiry dates in a 4N format.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $ExpirationDate;
    /**
     * The MaskedCardID
     * Meta information extracted from the WSDL
     * - documentation: Concealed credit card number, Example: xxxxxxxxxxxx9922 | Data type for Masked Payment Card ID.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,19}
     * @var string
     */
    public $MaskedCardID;
    /**
     * The PaymentInstrumentOwnershipCode
     * Meta information extracted from the WSDL
     * - documentation: Owner of the Payment Instrument. For example, Seller would mean the Seller is using their own card, BSP/ARC etc | Ownership Type Code
     * - base: OwnershipTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInstrumentOwnershipCode;
    /**
     * The ProtectedCardID
     * Meta information extracted from the WSDL
     * - documentation: Payment card number protected in a non format preserving fashion. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProtectedCardID;
    /**
     * The ReconciliationID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the individual for this specific transaction when the card is shared (for example, corporate card). This ID is typically used for payment reconciliation. It could be a client reference, cost center or a project number (PO
     * Number) | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReconciliationID;
    /**
     * The SecurePaymentAuthenticationInstructionsVersion1
     * Meta information extracted from the WSDL
     * - documentation: Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable to cardholder to authenticate. Applicable for 3D Secure Version V 1.0.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public $SecurePaymentAuthenticationInstructionsVersion1;
    /**
     * The SecurePaymentAuthenticationInstructionsVersion2
     * Meta information extracted from the WSDL
     * - documentation: Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable the cardholder to authenticate. Applicable for 3D-Secure. Applicable for 3D Secure Version V 2.0.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentAuthenticationInstructionsVersion2Type
     */
    public $SecurePaymentAuthenticationInstructionsVersion2;
    /**
     * The SecurePaymentVersion1
     * Meta information extracted from the WSDL
     * - documentation: Contains the indicators and fields that convey the result of the 3D Secure authentication transaction. Applicable for 3D Secure Version V 1.0.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentVersion1Type
     */
    public $SecurePaymentVersion1;
    /**
     * The SecurePaymentVersion2
     * Meta information extracted from the WSDL
     * - documentation: Contains all information for the result of 3D-Secure authentication process. Applicable to 3DS v2.0 and higher.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentVersion2Type
     */
    public $SecurePaymentVersion2;
    /**
     * The SecureProgram
     * Meta information extracted from the WSDL
     * - documentation: Contains enrolment information of the Payment Card. e.g. Verified by Visa.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecureProgramType
     */
    public $SecureProgram;
    /**
     * The TokenizedCardID
     * Meta information extracted from the WSDL
     * - documentation: An identifier corresponding to a set of payment card details, used between merchant and payment card service provider. | An identifier is a character string used to uniquely identify one instance of an object within an identification
     * scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TokenizedCardID;
    /**
     * Constructor method for ReceiptPaymentCardType
     * @uses ReceiptPaymentCardType::setCardBrandCode()
     * @uses ReceiptPaymentCardType::setCardholderAddress()
     * @uses ReceiptPaymentCardType::setCardHolderName()
     * @uses ReceiptPaymentCardType::setCardIssuerName()
     * @uses ReceiptPaymentCardType::setCardIssuingCountryCode()
     * @uses ReceiptPaymentCardType::setCardNumber()
     * @uses ReceiptPaymentCardType::setCardProductTypeCode()
     * @uses ReceiptPaymentCardType::setCardSecurityCode()
     * @uses ReceiptPaymentCardType::setCardSeqNumber()
     * @uses ReceiptPaymentCardType::setCardTypeText()
     * @uses ReceiptPaymentCardType::setCryptographyKey()
     * @uses ReceiptPaymentCardType::setEffectiveDate()
     * @uses ReceiptPaymentCardType::setEncryptedData()
     * @uses ReceiptPaymentCardType::setExpirationDate()
     * @uses ReceiptPaymentCardType::setMaskedCardID()
     * @uses ReceiptPaymentCardType::setPaymentInstrumentOwnershipCode()
     * @uses ReceiptPaymentCardType::setProtectedCardID()
     * @uses ReceiptPaymentCardType::setReconciliationID()
     * @uses ReceiptPaymentCardType::setSecurePaymentAuthenticationInstructionsVersion1()
     * @uses ReceiptPaymentCardType::setSecurePaymentAuthenticationInstructionsVersion2()
     * @uses ReceiptPaymentCardType::setSecurePaymentVersion1()
     * @uses ReceiptPaymentCardType::setSecurePaymentVersion2()
     * @uses ReceiptPaymentCardType::setSecureProgram()
     * @uses ReceiptPaymentCardType::setTokenizedCardID()
     * @param string $cardBrandCode
     * @param \StructType\PostalAddressType $cardholderAddress
     * @param string $cardHolderName
     * @param string $cardIssuerName
     * @param string $cardIssuingCountryCode
     * @param string $cardNumber
     * @param string $cardProductTypeCode
     * @param string $cardSecurityCode
     * @param float $cardSeqNumber
     * @param string $cardTypeText
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @param string $effectiveDate
     * @param \StructType\EncryptedDataType $encryptedData
     * @param string $expirationDate
     * @param string $maskedCardID
     * @param string $paymentInstrumentOwnershipCode
     * @param string $protectedCardID
     * @param string $reconciliationID
     * @param \StructType\SecurePaymentAuthenticationInstructionsVersion1Type $securePaymentAuthenticationInstructionsVersion1
     * @param \StructType\SecurePaymentAuthenticationInstructionsVersion2Type $securePaymentAuthenticationInstructionsVersion2
     * @param \StructType\SecurePaymentVersion1Type $securePaymentVersion1
     * @param \StructType\SecurePaymentVersion2Type $securePaymentVersion2
     * @param \StructType\SecureProgramType $secureProgram
     * @param string $tokenizedCardID
     */
    public function __construct($cardBrandCode = null, \StructType\PostalAddressType $cardholderAddress = null, $cardHolderName = null, $cardIssuerName = null, $cardIssuingCountryCode = null, $cardNumber = null, $cardProductTypeCode = null, $cardSecurityCode = null, $cardSeqNumber = null, $cardTypeText = null, \StructType\CryptographyKeyType $cryptographyKey = null, $effectiveDate = null, \StructType\EncryptedDataType $encryptedData = null, $expirationDate = null, $maskedCardID = null, $paymentInstrumentOwnershipCode = null, $protectedCardID = null, $reconciliationID = null, \StructType\SecurePaymentAuthenticationInstructionsVersion1Type $securePaymentAuthenticationInstructionsVersion1 = null, \StructType\SecurePaymentAuthenticationInstructionsVersion2Type $securePaymentAuthenticationInstructionsVersion2 = null, \StructType\SecurePaymentVersion1Type $securePaymentVersion1 = null, \StructType\SecurePaymentVersion2Type $securePaymentVersion2 = null, \StructType\SecureProgramType $secureProgram = null, $tokenizedCardID = null)
    {
        $this
            ->setCardBrandCode($cardBrandCode)
            ->setCardholderAddress($cardholderAddress)
            ->setCardHolderName($cardHolderName)
            ->setCardIssuerName($cardIssuerName)
            ->setCardIssuingCountryCode($cardIssuingCountryCode)
            ->setCardNumber($cardNumber)
            ->setCardProductTypeCode($cardProductTypeCode)
            ->setCardSecurityCode($cardSecurityCode)
            ->setCardSeqNumber($cardSeqNumber)
            ->setCardTypeText($cardTypeText)
            ->setCryptographyKey($cryptographyKey)
            ->setEffectiveDate($effectiveDate)
            ->setEncryptedData($encryptedData)
            ->setExpirationDate($expirationDate)
            ->setMaskedCardID($maskedCardID)
            ->setPaymentInstrumentOwnershipCode($paymentInstrumentOwnershipCode)
            ->setProtectedCardID($protectedCardID)
            ->setReconciliationID($reconciliationID)
            ->setSecurePaymentAuthenticationInstructionsVersion1($securePaymentAuthenticationInstructionsVersion1)
            ->setSecurePaymentAuthenticationInstructionsVersion2($securePaymentAuthenticationInstructionsVersion2)
            ->setSecurePaymentVersion1($securePaymentVersion1)
            ->setSecurePaymentVersion2($securePaymentVersion2)
            ->setSecureProgram($secureProgram)
            ->setTokenizedCardID($tokenizedCardID);
    }
    /**
     * Get CardBrandCode value
     * @return string|null
     */
    public function getCardBrandCode()
    {
        return $this->CardBrandCode;
    }
    /**
     * Set CardBrandCode value
     * @param string $cardBrandCode
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardBrandCode($cardBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardBrandCode) && !is_string($cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBrandCode, true), gettype($cardBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($cardBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($cardBrandCode, true)), __LINE__);
        }
        $this->CardBrandCode = $cardBrandCode;
        return $this;
    }
    /**
     * Get CardholderAddress value
     * @return \StructType\PostalAddressType|null
     */
    public function getCardholderAddress()
    {
        return $this->CardholderAddress;
    }
    /**
     * Set CardholderAddress value
     * @param \StructType\PostalAddressType $cardholderAddress
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardholderAddress(\StructType\PostalAddressType $cardholderAddress = null)
    {
        $this->CardholderAddress = $cardholderAddress;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CardIssuerName value
     * @return string|null
     */
    public function getCardIssuerName()
    {
        return $this->CardIssuerName;
    }
    /**
     * Set CardIssuerName value
     * @param string $cardIssuerName
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardIssuerName($cardIssuerName = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuerName) && !is_string($cardIssuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuerName, true), gettype($cardIssuerName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cardIssuerName) && mb_strlen($cardIssuerName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($cardIssuerName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cardIssuerName) && mb_strlen($cardIssuerName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cardIssuerName)), __LINE__);
        }
        $this->CardIssuerName = $cardIssuerName;
        return $this;
    }
    /**
     * Get CardIssuingCountryCode value
     * @return string|null
     */
    public function getCardIssuingCountryCode()
    {
        return $this->CardIssuingCountryCode;
    }
    /**
     * Set CardIssuingCountryCode value
     * @param string $cardIssuingCountryCode
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardIssuingCountryCode($cardIssuingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuingCountryCode) && !is_string($cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuingCountryCode, true), gettype($cardIssuingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($cardIssuingCountryCode) && !preg_match('/[A-Z]{2}/', $cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($cardIssuingCountryCode, true)), __LINE__);
        }
        $this->CardIssuingCountryCode = $cardIssuingCountryCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9X]{1,19})
        if (!is_null($cardNumber) && !preg_match('/[0-9X]{1,19}/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9X]{1,19}', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardProductTypeCode value
     * @return string|null
     */
    public function getCardProductTypeCode()
    {
        return $this->CardProductTypeCode;
    }
    /**
     * Set CardProductTypeCode value
     * @param string $cardProductTypeCode
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardProductTypeCode($cardProductTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductTypeCode) && !is_string($cardProductTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductTypeCode, true), gettype($cardProductTypeCode)), __LINE__);
        }
        $this->CardProductTypeCode = $cardProductTypeCode;
        return $this;
    }
    /**
     * Get CardSecurityCode value
     * @return string|null
     */
    public function getCardSecurityCode()
    {
        return $this->CardSecurityCode;
    }
    /**
     * Set CardSecurityCode value
     * @param string $cardSecurityCode
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardSecurityCode) && !is_string($cardSecurityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSecurityCode, true), gettype($cardSecurityCode)), __LINE__);
        }
        $this->CardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Get CardSeqNumber value
     * @return float|null
     */
    public function getCardSeqNumber()
    {
        return $this->CardSeqNumber;
    }
    /**
     * Set CardSeqNumber value
     * @param float $cardSeqNumber
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardSeqNumber($cardSeqNumber = null)
    {
        // validation for constraint: float
        if (!is_null($cardSeqNumber) && !(is_float($cardSeqNumber) || is_numeric($cardSeqNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cardSeqNumber, true), gettype($cardSeqNumber)), __LINE__);
        }
        $this->CardSeqNumber = $cardSeqNumber;
        return $this;
    }
    /**
     * Get CardTypeText value
     * @return string|null
     */
    public function getCardTypeText()
    {
        return $this->CardTypeText;
    }
    /**
     * Set CardTypeText value
     * @param string $cardTypeText
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCardTypeText($cardTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeText) && !is_string($cardTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeText, true), gettype($cardTypeText)), __LINE__);
        }
        $this->CardTypeText = $cardTypeText;
        return $this;
    }
    /**
     * Get CryptographyKey value
     * @return \StructType\CryptographyKeyType|null
     */
    public function getCryptographyKey()
    {
        return $this->CryptographyKey;
    }
    /**
     * Set CryptographyKey value
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setCryptographyKey(\StructType\CryptographyKeyType $cryptographyKey = null)
    {
        $this->CryptographyKey = $cryptographyKey;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($effectiveDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($effectiveDate, true)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get EncryptedData value
     * @return \StructType\EncryptedDataType|null
     */
    public function getEncryptedData()
    {
        return $this->EncryptedData;
    }
    /**
     * Set EncryptedData value
     * @param \StructType\EncryptedDataType $encryptedData
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setEncryptedData(\StructType\EncryptedDataType $encryptedData = null)
    {
        $this->EncryptedData = $encryptedData;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($expirationDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($expirationDate, true)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get MaskedCardID value
     * @return string|null
     */
    public function getMaskedCardID()
    {
        return $this->MaskedCardID;
    }
    /**
     * Set MaskedCardID value
     * @param string $maskedCardID
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setMaskedCardID($maskedCardID = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardID) && !is_string($maskedCardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedCardID, true), gettype($maskedCardID)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,19})
        if (!is_null($maskedCardID) && !preg_match('/[0-9a-zA-Z]{1,19}/', $maskedCardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,19}', var_export($maskedCardID, true)), __LINE__);
        }
        $this->MaskedCardID = $maskedCardID;
        return $this;
    }
    /**
     * Get PaymentInstrumentOwnershipCode value
     * @return string|null
     */
    public function getPaymentInstrumentOwnershipCode()
    {
        return $this->PaymentInstrumentOwnershipCode;
    }
    /**
     * Set PaymentInstrumentOwnershipCode value
     * @param string $paymentInstrumentOwnershipCode
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setPaymentInstrumentOwnershipCode($paymentInstrumentOwnershipCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstrumentOwnershipCode) && !is_string($paymentInstrumentOwnershipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstrumentOwnershipCode, true), gettype($paymentInstrumentOwnershipCode)), __LINE__);
        }
        $this->PaymentInstrumentOwnershipCode = $paymentInstrumentOwnershipCode;
        return $this;
    }
    /**
     * Get ProtectedCardID value
     * @return string|null
     */
    public function getProtectedCardID()
    {
        return $this->ProtectedCardID;
    }
    /**
     * Set ProtectedCardID value
     * @param string $protectedCardID
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setProtectedCardID($protectedCardID = null)
    {
        // validation for constraint: string
        if (!is_null($protectedCardID) && !is_string($protectedCardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protectedCardID, true), gettype($protectedCardID)), __LINE__);
        }
        $this->ProtectedCardID = $protectedCardID;
        return $this;
    }
    /**
     * Get ReconciliationID value
     * @return string|null
     */
    public function getReconciliationID()
    {
        return $this->ReconciliationID;
    }
    /**
     * Set ReconciliationID value
     * @param string $reconciliationID
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setReconciliationID($reconciliationID = null)
    {
        // validation for constraint: string
        if (!is_null($reconciliationID) && !is_string($reconciliationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciliationID, true), gettype($reconciliationID)), __LINE__);
        }
        $this->ReconciliationID = $reconciliationID;
        return $this;
    }
    /**
     * Get SecurePaymentAuthenticationInstructionsVersion1 value
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type|null
     */
    public function getSecurePaymentAuthenticationInstructionsVersion1()
    {
        return $this->SecurePaymentAuthenticationInstructionsVersion1;
    }
    /**
     * Set SecurePaymentAuthenticationInstructionsVersion1 value
     * @param \StructType\SecurePaymentAuthenticationInstructionsVersion1Type $securePaymentAuthenticationInstructionsVersion1
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setSecurePaymentAuthenticationInstructionsVersion1(\StructType\SecurePaymentAuthenticationInstructionsVersion1Type $securePaymentAuthenticationInstructionsVersion1 = null)
    {
        $this->SecurePaymentAuthenticationInstructionsVersion1 = $securePaymentAuthenticationInstructionsVersion1;
        return $this;
    }
    /**
     * Get SecurePaymentAuthenticationInstructionsVersion2 value
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion2Type|null
     */
    public function getSecurePaymentAuthenticationInstructionsVersion2()
    {
        return $this->SecurePaymentAuthenticationInstructionsVersion2;
    }
    /**
     * Set SecurePaymentAuthenticationInstructionsVersion2 value
     * @param \StructType\SecurePaymentAuthenticationInstructionsVersion2Type $securePaymentAuthenticationInstructionsVersion2
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setSecurePaymentAuthenticationInstructionsVersion2(\StructType\SecurePaymentAuthenticationInstructionsVersion2Type $securePaymentAuthenticationInstructionsVersion2 = null)
    {
        $this->SecurePaymentAuthenticationInstructionsVersion2 = $securePaymentAuthenticationInstructionsVersion2;
        return $this;
    }
    /**
     * Get SecurePaymentVersion1 value
     * @return \StructType\SecurePaymentVersion1Type|null
     */
    public function getSecurePaymentVersion1()
    {
        return $this->SecurePaymentVersion1;
    }
    /**
     * Set SecurePaymentVersion1 value
     * @param \StructType\SecurePaymentVersion1Type $securePaymentVersion1
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setSecurePaymentVersion1(\StructType\SecurePaymentVersion1Type $securePaymentVersion1 = null)
    {
        $this->SecurePaymentVersion1 = $securePaymentVersion1;
        return $this;
    }
    /**
     * Get SecurePaymentVersion2 value
     * @return \StructType\SecurePaymentVersion2Type|null
     */
    public function getSecurePaymentVersion2()
    {
        return $this->SecurePaymentVersion2;
    }
    /**
     * Set SecurePaymentVersion2 value
     * @param \StructType\SecurePaymentVersion2Type $securePaymentVersion2
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setSecurePaymentVersion2(\StructType\SecurePaymentVersion2Type $securePaymentVersion2 = null)
    {
        $this->SecurePaymentVersion2 = $securePaymentVersion2;
        return $this;
    }
    /**
     * Get SecureProgram value
     * @return \StructType\SecureProgramType|null
     */
    public function getSecureProgram()
    {
        return $this->SecureProgram;
    }
    /**
     * Set SecureProgram value
     * @param \StructType\SecureProgramType $secureProgram
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setSecureProgram(\StructType\SecureProgramType $secureProgram = null)
    {
        $this->SecureProgram = $secureProgram;
        return $this;
    }
    /**
     * Get TokenizedCardID value
     * @return string|null
     */
    public function getTokenizedCardID()
    {
        return $this->TokenizedCardID;
    }
    /**
     * Set TokenizedCardID value
     * @param string $tokenizedCardID
     * @return \StructType\ReceiptPaymentCardType
     */
    public function setTokenizedCardID($tokenizedCardID = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedCardID) && !is_string($tokenizedCardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedCardID, true), gettype($tokenizedCardID)), __LINE__);
        }
        $this->TokenizedCardID = $tokenizedCardID;
        return $this;
    }
}
