<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptIATA_EasyPayType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specialization for Payment Processing Summary. IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
 * @subpackage Structs
 */
class ReceiptIATA_EasyPayType extends AbstractStructBase
{
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - documentation: Authorization result Approval code | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovalCode;
    /**
     * The IATA_EasyPayEncryptedData
     * Meta information extracted from the WSDL
     * - documentation: container for the encrypted Easy Pay data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_EasyPayEncryptedDataType
     */
    public $IATA_EasyPayEncryptedData;
    /**
     * Constructor method for ReceiptIATA_EasyPayType
     * @uses ReceiptIATA_EasyPayType::setApprovalCode()
     * @uses ReceiptIATA_EasyPayType::setIATA_EasyPayEncryptedData()
     * @param string $approvalCode
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     */
    public function __construct($approvalCode = null, \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null)
    {
        $this
            ->setApprovalCode($approvalCode)
            ->setIATA_EasyPayEncryptedData($iATA_EasyPayEncryptedData);
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\ReceiptIATA_EasyPayType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get IATA_EasyPayEncryptedData value
     * @return \StructType\IATA_EasyPayEncryptedDataType|null
     */
    public function getIATA_EasyPayEncryptedData()
    {
        return $this->IATA_EasyPayEncryptedData;
    }
    /**
     * Set IATA_EasyPayEncryptedData value
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     * @return \StructType\ReceiptIATA_EasyPayType
     */
    public function setIATA_EasyPayEncryptedData(\StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null)
    {
        $this->IATA_EasyPayEncryptedData = $iATA_EasyPayEncryptedData;
        return $this;
    }
}
