<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSA_KeyValueType StructType
 * Meta information extracted from the WSDL
 * - documentation: An RSA (asymmetric encryption algorithm) public key used to encrypt data.
 * @subpackage Structs
 */
class RSA_KeyValueType extends AbstractStructBase
{
    /**
     * The Exponent
     * Meta information extracted from the WSDL
     * - documentation: A Exponent Binary Object
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BinaryObjectType
     */
    public $Exponent;
    /**
     * The Modulus
     * Meta information extracted from the WSDL
     * - documentation: A Modulus Binary object.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BinaryObjectType
     */
    public $Modulus;
    /**
     * Constructor method for RSA_KeyValueType
     * @uses RSA_KeyValueType::setExponent()
     * @uses RSA_KeyValueType::setModulus()
     * @param \StructType\BinaryObjectType $exponent
     * @param \StructType\BinaryObjectType $modulus
     */
    public function __construct(\StructType\BinaryObjectType $exponent = null, \StructType\BinaryObjectType $modulus = null)
    {
        $this
            ->setExponent($exponent)
            ->setModulus($modulus);
    }
    /**
     * Get Exponent value
     * @return \StructType\BinaryObjectType
     */
    public function getExponent()
    {
        return $this->Exponent;
    }
    /**
     * Set Exponent value
     * @param \StructType\BinaryObjectType $exponent
     * @return \StructType\RSA_KeyValueType
     */
    public function setExponent(\StructType\BinaryObjectType $exponent = null)
    {
        $this->Exponent = $exponent;
        return $this;
    }
    /**
     * Get Modulus value
     * @return \StructType\BinaryObjectType
     */
    public function getModulus()
    {
        return $this->Modulus;
    }
    /**
     * Set Modulus value
     * @param \StructType\BinaryObjectType $modulus
     * @return \StructType\RSA_KeyValueType
     */
    public function setModulus(\StructType\BinaryObjectType $modulus = null)
    {
        $this->Modulus = $modulus;
        return $this;
    }
}
