<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RBD_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Reservation Booking Designator. A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium,
 * 'D' for Business Discounted. There will typically be several RBDs defined for a given Cabin Type. Business Identifier Fields: - RBD Code
 * @subpackage Structs
 */
class RBD_Type extends AbstractStructBase
{
    /**
     * The RBD_Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RBD_Code;
    /**
     * Constructor method for RBD_Type
     * @uses RBD_Type::setRBD_Code()
     * @param string $rBD_Code
     */
    public function __construct($rBD_Code = null)
    {
        $this
            ->setRBD_Code($rBD_Code);
    }
    /**
     * Get RBD_Code value
     * @return string
     */
    public function getRBD_Code()
    {
        return $this->RBD_Code;
    }
    /**
     * Set RBD_Code value
     * @param string $rBD_Code
     * @return \StructType\RBD_Type
     */
    public function setRBD_Code($rBD_Code = null)
    {
        // validation for constraint: string
        if (!is_null($rBD_Code) && !is_string($rBD_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rBD_Code, true), gettype($rBD_Code)), __LINE__);
        }
        $this->RBD_Code = $rBD_Code;
        return $this;
    }
}
