<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for provider StructType
 * @subpackage Structs
 */
class Provider extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The session
     * @var string
     */
    public $session;
    /**
     * The reset
     * @var string
     */
    public $reset;
    /**
     * The group
     * @var string
     */
    public $group;
    /**
     * The vendor
     * @var string
     */
    public $vendor;
    /**
     * The env
     * @var string
     */
    public $env;
    /**
     * The force_tax_recalc
     * @var string
     */
    public $force_tax_recalc;
    /**
     * The airline
     * Meta information extracted from the WSDL
     * - documentation: Example:DY
     * @var string
     */
    public $airline;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Example: Y
     * @var string
     */
    public $Taxes;
    /**
     * The mergeAllowance
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $mergeAllowance;
    /**
     * Constructor method for provider
     * @uses Provider::set_()
     * @uses Provider::setSession()
     * @uses Provider::setReset()
     * @uses Provider::setGroup()
     * @uses Provider::setVendor()
     * @uses Provider::setEnv()
     * @uses Provider::setForce_tax_recalc()
     * @uses Provider::setAirline()
     * @uses Provider::setTaxes()
     * @uses Provider::setMergeAllowance()
     * @param string $_
     * @param string $session
     * @param string $reset
     * @param string $group
     * @param string $vendor
     * @param string $env
     * @param string $force_tax_recalc
     * @param string $airline
     * @param string $taxes
     * @param string $mergeAllowance
     */
    public function __construct($_ = null, $session = null, $reset = null, $group = null, $vendor = null, $env = null, $force_tax_recalc = null, $airline = null, $taxes = null, $mergeAllowance = null)
    {
        $this
            ->set_($_)
            ->setSession($session)
            ->setReset($reset)
            ->setGroup($group)
            ->setVendor($vendor)
            ->setEnv($env)
            ->setForce_tax_recalc($force_tax_recalc)
            ->setAirline($airline)
            ->setTaxes($taxes)
            ->setMergeAllowance($mergeAllowance);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Provider
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param string $session
     * @return \StructType\Provider
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get reset value
     * @return string|null
     */
    public function getReset()
    {
        return $this->reset;
    }
    /**
     * Set reset value
     * @param string $reset
     * @return \StructType\Provider
     */
    public function setReset($reset = null)
    {
        // validation for constraint: string
        if (!is_null($reset) && !is_string($reset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reset, true), gettype($reset)), __LINE__);
        }
        $this->reset = $reset;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \StructType\Provider
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param string $vendor
     * @return \StructType\Provider
     */
    public function setVendor($vendor = null)
    {
        // validation for constraint: string
        if (!is_null($vendor) && !is_string($vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendor, true), gettype($vendor)), __LINE__);
        }
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get env value
     * @return string|null
     */
    public function getEnv()
    {
        return $this->env;
    }
    /**
     * Set env value
     * @param string $env
     * @return \StructType\Provider
     */
    public function setEnv($env = null)
    {
        // validation for constraint: string
        if (!is_null($env) && !is_string($env)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($env, true), gettype($env)), __LINE__);
        }
        $this->env = $env;
        return $this;
    }
    /**
     * Get force_tax_recalc value
     * @return string|null
     */
    public function getForce_tax_recalc()
    {
        return $this->{'force-tax-recalc'};
    }
    /**
     * Set force_tax_recalc value
     * @param string $force_tax_recalc
     * @return \StructType\Provider
     */
    public function setForce_tax_recalc($force_tax_recalc = null)
    {
        // validation for constraint: string
        if (!is_null($force_tax_recalc) && !is_string($force_tax_recalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($force_tax_recalc, true), gettype($force_tax_recalc)), __LINE__);
        }
        $this->force_tax_recalc = $this->{'force-tax-recalc'} = $force_tax_recalc;
        return $this;
    }
    /**
     * Get airline value
     * @return string|null
     */
    public function getAirline()
    {
        return $this->airline;
    }
    /**
     * Set airline value
     * @param string $airline
     * @return \StructType\Provider
     */
    public function setAirline($airline = null)
    {
        // validation for constraint: string
        if (!is_null($airline) && !is_string($airline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airline, true), gettype($airline)), __LINE__);
        }
        $this->airline = $airline;
        return $this;
    }
    /**
     * Get Taxes value
     * @return string|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param string $taxes
     * @return \StructType\Provider
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: string
        if (!is_null($taxes) && !is_string($taxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get mergeAllowance value
     * @return string|null
     */
    public function getMergeAllowance()
    {
        return $this->mergeAllowance;
    }
    /**
     * Set mergeAllowance value
     * @param string $mergeAllowance
     * @return \StructType\Provider
     */
    public function setMergeAllowance($mergeAllowance = null)
    {
        // validation for constraint: string
        if (!is_null($mergeAllowance) && !is_string($mergeAllowance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergeAllowance, true), gettype($mergeAllowance)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($mergeAllowance) && mb_strlen($mergeAllowance) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($mergeAllowance)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mergeAllowance) && mb_strlen($mergeAllowance) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mergeAllowance)), __LINE__);
        }
        $this->mergeAllowance = $mergeAllowance;
        return $this;
    }
}
