<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgramAccountType StructType
 * Meta information extracted from the WSDL
 * - documentation: An account which provides access to discounted or negotiated prices.
 * @subpackage Structs
 */
class ProgramAccountType extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the program account. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountID;
    /**
     * Constructor method for ProgramAccountType
     * @uses ProgramAccountType::setAccountID()
     * @param string $accountID
     */
    public function __construct($accountID = null)
    {
        $this
            ->setAccountID($accountID);
    }
    /**
     * Get AccountID value
     * @return string
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \StructType\ProgramAccountType
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
}
