<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgamContractType StructType
 * Meta information extracted from the WSDL
 * - documentation: An agreement which provides access to discounted or negotiated prices.
 * @subpackage Structs
 */
class ProgamContractType extends AbstractStructBase
{
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the program contract. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContractID;
    /**
     * Constructor method for ProgamContractType
     * @uses ProgamContractType::setContractID()
     * @param string $contractID
     */
    public function __construct($contractID = null)
    {
        $this
            ->setContractID($contractID);
    }
    /**
     * Get ContractID value
     * @return string
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param string $contractID
     * @return \StructType\ProgamContractType
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: string
        if (!is_null($contractID) && !is_string($contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractID, true), gettype($contractID)), __LINE__);
        }
        $this->ContractID = $contractID;
        return $this;
    }
}
