<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceVarianceRuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
 * @subpackage Structs
 */
class PriceVarianceRuleType extends AbstractStructBase
{
    /**
     * The AcceptableVarianceAmount
     * Meta information extracted from the WSDL
     * - documentation: Acceptable amount by which the price at time of payment can vary. Example: 20 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $AcceptableVarianceAmount;
    /**
     * The RuleID
     * Meta information extracted from the WSDL
     * - documentation: Rule ID assigned by the owner. Example: PRICERULE001. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RuleID;
    /**
     * The AcceptableVariancePercent
     * Meta information extracted from the WSDL
     * - documentation: Acceptable percent by which the price at time of payment can vary. Example: 2 percent | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AcceptableVariancePercent;
    /**
     * The EffectivePeriodDuration
     * Meta information extracted from the WSDL
     * - documentation: Rule Effective Period. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectivePeriodDuration;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Entity that owns/ assigned this Rule. If this is an airline, the IATA Airline Designator Code should be used. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name,
     * etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerName;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * The RuleName
     * Meta information extracted from the WSDL
     * - documentation: Rule Name. Example: Acceptable Price variance | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleName;
    /**
     * Constructor method for PriceVarianceRuleType
     * @uses PriceVarianceRuleType::setAcceptableVarianceAmount()
     * @uses PriceVarianceRuleType::setRuleID()
     * @uses PriceVarianceRuleType::setAcceptableVariancePercent()
     * @uses PriceVarianceRuleType::setEffectivePeriodDuration()
     * @uses PriceVarianceRuleType::setOwnerName()
     * @uses PriceVarianceRuleType::setRemark()
     * @uses PriceVarianceRuleType::setRuleName()
     * @param \StructType\AmountType $acceptableVarianceAmount
     * @param string $ruleID
     * @param float $acceptableVariancePercent
     * @param string $effectivePeriodDuration
     * @param string $ownerName
     * @param \StructType\RemarkType[] $remark
     * @param string $ruleName
     */
    public function __construct(\StructType\AmountType $acceptableVarianceAmount = null, $ruleID = null, $acceptableVariancePercent = null, $effectivePeriodDuration = null, $ownerName = null, array $remark = array(), $ruleName = null)
    {
        $this
            ->setAcceptableVarianceAmount($acceptableVarianceAmount)
            ->setRuleID($ruleID)
            ->setAcceptableVariancePercent($acceptableVariancePercent)
            ->setEffectivePeriodDuration($effectivePeriodDuration)
            ->setOwnerName($ownerName)
            ->setRemark($remark)
            ->setRuleName($ruleName);
    }
    /**
     * Get AcceptableVarianceAmount value
     * @return \StructType\AmountType
     */
    public function getAcceptableVarianceAmount()
    {
        return $this->AcceptableVarianceAmount;
    }
    /**
     * Set AcceptableVarianceAmount value
     * @param \StructType\AmountType $acceptableVarianceAmount
     * @return \StructType\PriceVarianceRuleType
     */
    public function setAcceptableVarianceAmount(\StructType\AmountType $acceptableVarianceAmount = null)
    {
        $this->AcceptableVarianceAmount = $acceptableVarianceAmount;
        return $this;
    }
    /**
     * Get RuleID value
     * @return string
     */
    public function getRuleID()
    {
        return $this->RuleID;
    }
    /**
     * Set RuleID value
     * @param string $ruleID
     * @return \StructType\PriceVarianceRuleType
     */
    public function setRuleID($ruleID = null)
    {
        // validation for constraint: string
        if (!is_null($ruleID) && !is_string($ruleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleID, true), gettype($ruleID)), __LINE__);
        }
        $this->RuleID = $ruleID;
        return $this;
    }
    /**
     * Get AcceptableVariancePercent value
     * @return float|null
     */
    public function getAcceptableVariancePercent()
    {
        return $this->AcceptableVariancePercent;
    }
    /**
     * Set AcceptableVariancePercent value
     * @param float $acceptableVariancePercent
     * @return \StructType\PriceVarianceRuleType
     */
    public function setAcceptableVariancePercent($acceptableVariancePercent = null)
    {
        // validation for constraint: float
        if (!is_null($acceptableVariancePercent) && !(is_float($acceptableVariancePercent) || is_numeric($acceptableVariancePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($acceptableVariancePercent, true), gettype($acceptableVariancePercent)), __LINE__);
        }
        $this->AcceptableVariancePercent = $acceptableVariancePercent;
        return $this;
    }
    /**
     * Get EffectivePeriodDuration value
     * @return string|null
     */
    public function getEffectivePeriodDuration()
    {
        return $this->EffectivePeriodDuration;
    }
    /**
     * Set EffectivePeriodDuration value
     * @param string $effectivePeriodDuration
     * @return \StructType\PriceVarianceRuleType
     */
    public function setEffectivePeriodDuration($effectivePeriodDuration = null)
    {
        // validation for constraint: string
        if (!is_null($effectivePeriodDuration) && !is_string($effectivePeriodDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectivePeriodDuration, true), gettype($effectivePeriodDuration)), __LINE__);
        }
        $this->EffectivePeriodDuration = $effectivePeriodDuration;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param string $ownerName
     * @return \StructType\PriceVarianceRuleType
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ownerName) && mb_strlen($ownerName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ownerName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ownerName) && mb_strlen($ownerName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ownerName)), __LINE__);
        }
        $this->OwnerName = $ownerName;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceVarianceRuleTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$priceVarianceRuleTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($priceVarianceRuleTypeRemarkItem) ? get_class($priceVarianceRuleTypeRemarkItem) : sprintf('%s(%s)', gettype($priceVarianceRuleTypeRemarkItem), var_export($priceVarianceRuleTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\PriceVarianceRuleType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\PriceVarianceRuleType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get RuleName value
     * @return string|null
     */
    public function getRuleName()
    {
        return $this->RuleName;
    }
    /**
     * Set RuleName value
     * @param string $ruleName
     * @return \StructType\PriceVarianceRuleType
     */
    public function setRuleName($ruleName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleName) && !is_string($ruleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleName, true), gettype($ruleName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ruleName) && mb_strlen($ruleName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ruleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ruleName) && mb_strlen($ruleName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ruleName)), __LINE__);
        }
        $this->RuleName = $ruleName;
        return $this;
    }
}
