<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount of money expected, required, or given in payment for something .
 * @subpackage Structs
 */
class PriceSummaryType extends AbstractStructBase
{
    /**
     * The LoyaltyUnitAmount
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Unit Amount
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyAmountType
     */
    public $LoyaltyUnitAmount;
    /**
     * The LoyaltyUnitName
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Unit Name | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyUnitName;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Amount
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * Constructor method for PriceSummaryType
     * @uses PriceSummaryType::setLoyaltyUnitAmount()
     * @uses PriceSummaryType::setLoyaltyUnitName()
     * @uses PriceSummaryType::setTotalAmount()
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @param string $loyaltyUnitName
     * @param \StructType\AmountType $totalAmount
     */
    public function __construct(\StructType\LoyaltyAmountType $loyaltyUnitAmount = null, $loyaltyUnitName = null, \StructType\AmountType $totalAmount = null)
    {
        $this
            ->setLoyaltyUnitAmount($loyaltyUnitAmount)
            ->setLoyaltyUnitName($loyaltyUnitName)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get LoyaltyUnitAmount value
     * @return \StructType\LoyaltyAmountType|null
     */
    public function getLoyaltyUnitAmount()
    {
        return $this->LoyaltyUnitAmount;
    }
    /**
     * Set LoyaltyUnitAmount value
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @return \StructType\PriceSummaryType
     */
    public function setLoyaltyUnitAmount(\StructType\LoyaltyAmountType $loyaltyUnitAmount = null)
    {
        $this->LoyaltyUnitAmount = $loyaltyUnitAmount;
        return $this;
    }
    /**
     * Get LoyaltyUnitName value
     * @return string|null
     */
    public function getLoyaltyUnitName()
    {
        return $this->LoyaltyUnitName;
    }
    /**
     * Set LoyaltyUnitName value
     * @param string $loyaltyUnitName
     * @return \StructType\PriceSummaryType
     */
    public function setLoyaltyUnitName($loyaltyUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyUnitName) && !is_string($loyaltyUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyUnitName, true), gettype($loyaltyUnitName)), __LINE__);
        }
        $this->LoyaltyUnitName = $loyaltyUnitName;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\PriceSummaryType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
