<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceCalendarType StructType
 * Meta information extracted from the WSDL
 * - documentation: Calendar based Flight Price. This capability supports multi-day calendar shopping, e.g. returning priced flight offers for a specified period before and/or after the actual requested date.
 * @subpackage Structs
 */
class PriceCalendarType extends AbstractStructBase
{
    /**
     * The PriceCalendarDate
     * Meta information extracted from the WSDL
     * - documentation: A Price Calendar Date
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PriceCalendarDateType[]
     */
    public $PriceCalendarDate;
    /**
     * The LeadPriceInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this is a lead calendar shopping price for a date that is prior to or after the required travel date. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $LeadPriceInd;
    /**
     * The PricedPTC
     * Meta information extracted from the WSDL
     * - documentation: Passenger Type summary information for an offer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PTC_OfferParametersType[]
     */
    public $PricedPTC;
    /**
     * The TotalPriceAmount
     * Meta information extracted from the WSDL
     * - documentation: The total Offer price for all passengers associated with the specified Origin Destination and Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalPriceAmount;
    /**
     * Constructor method for PriceCalendarType
     * @uses PriceCalendarType::setPriceCalendarDate()
     * @uses PriceCalendarType::setLeadPriceInd()
     * @uses PriceCalendarType::setPricedPTC()
     * @uses PriceCalendarType::setTotalPriceAmount()
     * @param \StructType\PriceCalendarDateType[] $priceCalendarDate
     * @param bool $leadPriceInd
     * @param \StructType\PTC_OfferParametersType[] $pricedPTC
     * @param \StructType\AmountType $totalPriceAmount
     */
    public function __construct(array $priceCalendarDate = array(), $leadPriceInd = null, array $pricedPTC = array(), \StructType\AmountType $totalPriceAmount = null)
    {
        $this
            ->setPriceCalendarDate($priceCalendarDate)
            ->setLeadPriceInd($leadPriceInd)
            ->setPricedPTC($pricedPTC)
            ->setTotalPriceAmount($totalPriceAmount);
    }
    /**
     * Get PriceCalendarDate value
     * @return \StructType\PriceCalendarDateType[]
     */
    public function getPriceCalendarDate()
    {
        return $this->PriceCalendarDate;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceCalendarDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceCalendarDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceCalendarDateForArrayConstraintsFromSetPriceCalendarDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceCalendarTypePriceCalendarDateItem) {
            // validation for constraint: itemType
            if (!$priceCalendarTypePriceCalendarDateItem instanceof \StructType\PriceCalendarDateType) {
                $invalidValues[] = is_object($priceCalendarTypePriceCalendarDateItem) ? get_class($priceCalendarTypePriceCalendarDateItem) : sprintf('%s(%s)', gettype($priceCalendarTypePriceCalendarDateItem), var_export($priceCalendarTypePriceCalendarDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceCalendarDate property can only contain items of type \StructType\PriceCalendarDateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceCalendarDate value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCalendarDateType[] $priceCalendarDate
     * @return \StructType\PriceCalendarType
     */
    public function setPriceCalendarDate(array $priceCalendarDate = array())
    {
        // validation for constraint: array
        if ('' !== ($priceCalendarDateArrayErrorMessage = self::validatePriceCalendarDateForArrayConstraintsFromSetPriceCalendarDate($priceCalendarDate))) {
            throw new \InvalidArgumentException($priceCalendarDateArrayErrorMessage, __LINE__);
        }
        $this->PriceCalendarDate = $priceCalendarDate;
        return $this;
    }
    /**
     * Add item to PriceCalendarDate value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCalendarDateType $item
     * @return \StructType\PriceCalendarType
     */
    public function addToPriceCalendarDate(\StructType\PriceCalendarDateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceCalendarDateType) {
            throw new \InvalidArgumentException(sprintf('The PriceCalendarDate property can only contain items of type \StructType\PriceCalendarDateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceCalendarDate[] = $item;
        return $this;
    }
    /**
     * Get LeadPriceInd value
     * @return bool|null
     */
    public function getLeadPriceInd()
    {
        return $this->LeadPriceInd;
    }
    /**
     * Set LeadPriceInd value
     * @param bool $leadPriceInd
     * @return \StructType\PriceCalendarType
     */
    public function setLeadPriceInd($leadPriceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($leadPriceInd) && !is_bool($leadPriceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leadPriceInd, true), gettype($leadPriceInd)), __LINE__);
        }
        $this->LeadPriceInd = $leadPriceInd;
        return $this;
    }
    /**
     * Get PricedPTC value
     * @return \StructType\PTC_OfferParametersType[]|null
     */
    public function getPricedPTC()
    {
        return $this->PricedPTC;
    }
    /**
     * This method is responsible for validating the values passed to the setPricedPTC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricedPTC method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricedPTCForArrayConstraintsFromSetPricedPTC(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceCalendarTypePricedPTCItem) {
            // validation for constraint: itemType
            if (!$priceCalendarTypePricedPTCItem instanceof \StructType\PTC_OfferParametersType) {
                $invalidValues[] = is_object($priceCalendarTypePricedPTCItem) ? get_class($priceCalendarTypePricedPTCItem) : sprintf('%s(%s)', gettype($priceCalendarTypePricedPTCItem), var_export($priceCalendarTypePricedPTCItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricedPTC property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricedPTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType[] $pricedPTC
     * @return \StructType\PriceCalendarType
     */
    public function setPricedPTC(array $pricedPTC = array())
    {
        // validation for constraint: array
        if ('' !== ($pricedPTCArrayErrorMessage = self::validatePricedPTCForArrayConstraintsFromSetPricedPTC($pricedPTC))) {
            throw new \InvalidArgumentException($pricedPTCArrayErrorMessage, __LINE__);
        }
        $this->PricedPTC = $pricedPTC;
        return $this;
    }
    /**
     * Add item to PricedPTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC_OfferParametersType $item
     * @return \StructType\PriceCalendarType
     */
    public function addToPricedPTC(\StructType\PTC_OfferParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTC_OfferParametersType) {
            throw new \InvalidArgumentException(sprintf('The PricedPTC property can only contain items of type \StructType\PTC_OfferParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PricedPTC[] = $item;
        return $this;
    }
    /**
     * Get TotalPriceAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalPriceAmount()
    {
        return $this->TotalPriceAmount;
    }
    /**
     * Set TotalPriceAmount value
     * @param \StructType\AmountType $totalPriceAmount
     * @return \StructType\PriceCalendarType
     */
    public function setTotalPriceAmount(\StructType\AmountType $totalPriceAmount = null)
    {
        $this->TotalPriceAmount = $totalPriceAmount;
        return $this;
    }
}
