<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceAndFareDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for Price and Fare detail information.
 * @subpackage Structs
 */
class PriceAndFareDetailsType extends AbstractStructBase
{
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * Constructor method for PriceAndFareDetailsType
     * @uses PriceAndFareDetailsType::setFareDetail()
     * @uses PriceAndFareDetailsType::setPrice()
     * @param \StructType\FareDetailType[] $fareDetail
     * @param \StructType\PriceType $price
     */
    public function __construct(array $fareDetail = array(), \StructType\PriceType $price = null)
    {
        $this
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceAndFareDetailsTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$priceAndFareDetailsTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($priceAndFareDetailsTypeFareDetailItem) ? get_class($priceAndFareDetailsTypeFareDetailItem) : sprintf('%s(%s)', gettype($priceAndFareDetailsTypeFareDetailItem), var_export($priceAndFareDetailsTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\PriceAndFareDetailsType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\PriceAndFareDetailsType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\PriceAndFareDetailsType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
