<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefLevelType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
 * @subpackage Structs
 */
class PrefLevelType extends AbstractStructBase
{
    /**
     * The PrefLevelCode
     * Meta information extracted from the WSDL
     * - documentation: Level of preference requested. Examples: Preferred, Required or Exclude.
     * - base: PrefLevelCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrefLevelCode;
    /**
     * Constructor method for PrefLevelType
     * @uses PrefLevelType::setPrefLevelCode()
     * @param string $prefLevelCode
     */
    public function __construct($prefLevelCode = null)
    {
        $this
            ->setPrefLevelCode($prefLevelCode);
    }
    /**
     * Get PrefLevelCode value
     * @return string
     */
    public function getPrefLevelCode()
    {
        return $this->PrefLevelCode;
    }
    /**
     * Set PrefLevelCode value
     * @param string $prefLevelCode
     * @return \StructType\PrefLevelType
     */
    public function setPrefLevelCode($prefLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($prefLevelCode) && !is_string($prefLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefLevelCode, true), gettype($prefLevelCode)), __LINE__);
        }
        $this->PrefLevelCode = $prefLevelCode;
        return $this;
    }
}
