<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefLevel StructType
 * Meta information extracted from the WSDL
 * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
 * @subpackage Structs
 */
class PrefLevel extends AbstractStructBase
{
    /**
     * The PrefLevelCode
     * @var string
     */
    public $PrefLevelCode;
    /**
     * Constructor method for PrefLevel
     * @uses PrefLevel::setPrefLevelCode()
     * @param string $prefLevelCode
     */
    public function __construct($prefLevelCode = null)
    {
        $this
            ->setPrefLevelCode($prefLevelCode);
    }
    /**
     * Get PrefLevelCode value
     * @return string|null
     */
    public function getPrefLevelCode()
    {
        return $this->PrefLevelCode;
    }
    /**
     * Set PrefLevelCode value
     * @uses \EnumType\PrefLevelCode::valueIsValid()
     * @uses \EnumType\PrefLevelCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prefLevelCode
     * @return \StructType\PrefLevel
     */
    public function setPrefLevelCode($prefLevelCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrefLevelCode::valueIsValid($prefLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrefLevelCode', is_array($prefLevelCode) ? implode(', ', $prefLevelCode) : var_export($prefLevelCode, true), implode(', ', \EnumType\PrefLevelCode::getValidValues())), __LINE__);
        }
        $this->PrefLevelCode = $prefLevelCode;
        return $this;
    }
}
