<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrePaidCertificateType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Pre-Paid Certificate
 * @subpackage Structs
 */
class PrePaidCertificateType extends AbstractStructBase
{
    /**
     * The AppText
     * Meta information extracted from the WSDL
     * - documentation: Application Text | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppText;
    /**
     * The EffectiveDateTime
     * Meta information extracted from the WSDL
     * - documentation: Effective Date Time | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDateTime;
    /**
     * The ExpiryDateTime
     * Meta information extracted from the WSDL
     * - documentation: Expiry Date Time | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDateTime;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Number | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Number;
    /**
     * Constructor method for PrePaidCertificateType
     * @uses PrePaidCertificateType::setAppText()
     * @uses PrePaidCertificateType::setEffectiveDateTime()
     * @uses PrePaidCertificateType::setExpiryDateTime()
     * @uses PrePaidCertificateType::setNumber()
     * @param string $appText
     * @param string $effectiveDateTime
     * @param string $expiryDateTime
     * @param float $number
     */
    public function __construct($appText = null, $effectiveDateTime = null, $expiryDateTime = null, $number = null)
    {
        $this
            ->setAppText($appText)
            ->setEffectiveDateTime($effectiveDateTime)
            ->setExpiryDateTime($expiryDateTime)
            ->setNumber($number);
    }
    /**
     * Get AppText value
     * @return string|null
     */
    public function getAppText()
    {
        return $this->AppText;
    }
    /**
     * Set AppText value
     * @param string $appText
     * @return \StructType\PrePaidCertificateType
     */
    public function setAppText($appText = null)
    {
        // validation for constraint: string
        if (!is_null($appText) && !is_string($appText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appText, true), gettype($appText)), __LINE__);
        }
        $this->AppText = $appText;
        return $this;
    }
    /**
     * Get EffectiveDateTime value
     * @return string|null
     */
    public function getEffectiveDateTime()
    {
        return $this->EffectiveDateTime;
    }
    /**
     * Set EffectiveDateTime value
     * @param string $effectiveDateTime
     * @return \StructType\PrePaidCertificateType
     */
    public function setEffectiveDateTime($effectiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateTime) && !is_string($effectiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDateTime, true), gettype($effectiveDateTime)), __LINE__);
        }
        $this->EffectiveDateTime = $effectiveDateTime;
        return $this;
    }
    /**
     * Get ExpiryDateTime value
     * @return string|null
     */
    public function getExpiryDateTime()
    {
        return $this->ExpiryDateTime;
    }
    /**
     * Set ExpiryDateTime value
     * @param string $expiryDateTime
     * @return \StructType\PrePaidCertificateType
     */
    public function setExpiryDateTime($expiryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateTime) && !is_string($expiryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateTime, true), gettype($expiryDateTime)), __LINE__);
        }
        $this->ExpiryDateTime = $expiryDateTime;
        return $this;
    }
    /**
     * Get Number value
     * @return float|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param float $number
     * @return \StructType\PrePaidCertificateType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: float
        if (!is_null($number) && !(is_float($number) || is_numeric($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
}
