<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a punishment imposed for breaking a law, rule, or contract.
 * @subpackage Structs
 */
class PenaltyType extends AbstractStructBase
{
    /**
     * The PenaltyID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of this Penalty instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PenaltyID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: This is a specialization of price when associated with a Penalty Base definition is: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PenaltyPriceType
     */
    public $Price;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Penalty type information. Examples: Cancellation, Change, NoShow, Upgrade, Other | Penalty Type Code
     * - base: PenaltyTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description of the applicable penalty. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $DescText;
    /**
     * The NetInd
     * Meta information extracted from the WSDL
     * - documentation: The airline informs the seller if the penalty is netted (True) (i.e. taken from any amount that airline will owe to customer consequently to the servicing) or to be paid (False) (i.e. charged to customer upfront any servicing action,
     * and even if customer benefits from a subsequent refund/ residual value). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NetInd;
    /**
     * Constructor method for PenaltyType
     * @uses PenaltyType::setPenaltyID()
     * @uses PenaltyType::setPrice()
     * @uses PenaltyType::setTypeCode()
     * @uses PenaltyType::setDescText()
     * @uses PenaltyType::setNetInd()
     * @param string $penaltyID
     * @param \StructType\PenaltyPriceType $price
     * @param string $typeCode
     * @param string[] $descText
     * @param bool $netInd
     */
    public function __construct($penaltyID = null, \StructType\PenaltyPriceType $price = null, $typeCode = null, array $descText = array(), $netInd = null)
    {
        $this
            ->setPenaltyID($penaltyID)
            ->setPrice($price)
            ->setTypeCode($typeCode)
            ->setDescText($descText)
            ->setNetInd($netInd);
    }
    /**
     * Get PenaltyID value
     * @return string
     */
    public function getPenaltyID()
    {
        return $this->PenaltyID;
    }
    /**
     * Set PenaltyID value
     * @param string $penaltyID
     * @return \StructType\PenaltyType
     */
    public function setPenaltyID($penaltyID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyID) && !is_string($penaltyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyID, true), gettype($penaltyID)), __LINE__);
        }
        $this->PenaltyID = $penaltyID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PenaltyPriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PenaltyPriceType $price
     * @return \StructType\PenaltyType
     */
    public function setPrice(\StructType\PenaltyPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\PenaltyType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get DescText value
     * @return string[]|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * This method is responsible for validating the values passed to the setDescText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescTextForArrayConstraintsFromSetDescText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $penaltyTypeDescTextItem) {
            // validation for constraint: itemType
            if (!is_string($penaltyTypeDescTextItem)) {
                $invalidValues[] = is_object($penaltyTypeDescTextItem) ? get_class($penaltyTypeDescTextItem) : sprintf('%s(%s)', gettype($penaltyTypeDescTextItem), var_export($penaltyTypeDescTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DescText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DescText value
     * @throws \InvalidArgumentException
     * @param string[] $descText
     * @return \StructType\PenaltyType
     */
    public function setDescText(array $descText = array())
    {
        // validation for constraint: array
        if ('' !== ($descTextArrayErrorMessage = self::validateDescTextForArrayConstraintsFromSetDescText($descText))) {
            throw new \InvalidArgumentException($descTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($descText) && count($descText) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Add item to DescText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PenaltyType
     */
    public function addToDescText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DescText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->DescText) && count($this->DescText) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->DescText)), __LINE__);
        }
        $this->DescText[] = $item;
        return $this;
    }
    /**
     * Get NetInd value
     * @return bool|null
     */
    public function getNetInd()
    {
        return $this->NetInd;
    }
    /**
     * Set NetInd value
     * @param bool $netInd
     * @return \StructType\PenaltyType
     */
    public function setNetInd($netInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netInd) && !is_bool($netInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netInd, true), gettype($netInd)), __LINE__);
        }
        $this->NetInd = $netInd;
        return $this;
    }
}
